#include "crypto.h"

#include <assert.h>

pp_eui64_t eui64_all={{255,255,255,255,255,255,255,255}};

int
pp_dc_sign_and_encrypt(char *data,size_t size,
		       int state,
		       pp_dc_privkey_t *privkey,
		       pp_dc_pubkey_t *pubkey,
		       pp_dc_cnode_t **node)
{
    *node=pp_dc_plain2cnode(pp_dc_plain_gen(data,size));

    if(state&PP_DC_SIGNED) {
	pp_dc_cnode_t *s;
	assert(privkey);
	s=pp_dc_signature2cnode(pp_dc_signature_sign(*node,PP_DC_HASH_SHA1,privkey));
	s->next=*node;
	*node=s;
    }

    *node=pp_dc_compressed2cnode(pp_dc_compressed_gen(*node));

    if(state&PP_DC_ENCRYPTED) {
	pp_dc_skey_t *skey=pp_dc_skey_gen();
	pp_dc_cnode_t *e;
	assert(pubkey);
	e=pp_dc_esk2cnode(pp_dc_skey2esk(skey,pubkey));
	e->next=pp_dc_encrypted2cnode(pp_dc_encrypted_gen(*node,skey));
	*node=e;
    }

    return 1;
}

size_t
pp_dc_decrypt_and_verify(pp_dc_cnode_t *node,
			   int *state,
			   pp_dc_privkey_t *privkey,
			   pp_dc_pubkey_t *pubkey,
			   char **data)
{
    *state=0;

    if(pp_dc_cnode2esk(node) &&
       pp_dc_cnode2encrypted(node->next)) {
	pp_dc_skey_t *skey;
	assert(privkey);
	skey=pp_dc_esk2skey(pp_dc_cnode2esk(node),privkey);

	if(skey && pp_dc_encrypted_decrypt(pp_dc_cnode2encrypted(node->next),skey)) {
	   *state|=PP_DC_ENCRYPTED;
	   node=node->next->un.encrypted->sub;
	}
    }

    if(pp_dc_cnode2compressed(node))
	node=node->un.compressed->sub;

    if(pubkey &&
       pp_dc_cnode2signature(node) &&
       pp_dc_cnode2plain(node->next)) {
	if(pp_dc_signature_verify(node->next,pp_dc_cnode2signature(node),pubkey))
	    *state|=PP_DC_SIGNED;
	node=node->next;
    }

    if(pp_dc_cnode2signature(node))
	node=node->next;

    if(pp_dc_cnode2plain(node)) {
	*data=(char*)node->un.plain->data;
	return node->un.plain->size;
    }
    else return 0;
}

int
pp_dc_decrypt(pp_dc_cnode_t *node,pp_dc_privkey_t *privkey)
{
    if(privkey && 
       pp_dc_cnode2esk(node) &&
       pp_dc_cnode2encrypted(node->next)) {
	pp_dc_skey_t *skey;
	assert(privkey);
	skey=pp_dc_esk2skey(pp_dc_cnode2esk(node),privkey);

	if(skey && pp_dc_encrypted_decrypt(pp_dc_cnode2encrypted(node->next),skey))
	    return 1;
    }
    return 0;
}

int
pp_dc_verify(pp_dc_cnode_t *node,pp_dc_pubkey_t *pubkey)
{
    if(pp_dc_cnode2esk(node) &&
       pp_dc_cnode2encrypted(node->next))
	node=node->next->un.encrypted->sub;

    if(!node)
	return 0;

    if(pp_dc_cnode2compressed(node))
	node=node->un.compressed->sub;

    if(pubkey &&
       pp_dc_cnode2signature(node) &&
       pp_dc_cnode2plain(node->next) &&
       pp_dc_signature_verify(node->next,pp_dc_cnode2signature(node),pubkey))
	    return 1;

    return 0;
}
