#ifndef _PP_FLASH_ACCESS_H
#define _PP_FLASH_ACCESS_H

#define PP_FA_ROOT "/flashdisk/"
//#define PP_FA_ROOT "/home/tweb/tmp/flashdisk/"

#define dont__USE_FANCY_WRITE_METHODS__
/* We do not use the fancy flash access write methods for now, since they do
   not improve system behaviour.
   The aim of this lib was to provide methods to check the writable space on
   flashdisk before writing and to reserve an amount of guaranteed avaliable
   space for writing by serializing write access. This is IMHO impossible since
   neither the maximum size of writable data (!= free space, e.g. df returns)
   nor the physical size of an already stored file can be determined due to the
   (desired) compression behaviour of jffs2.
   For the moment, free space on our flash partition should not be the point,
   so the more specialized parts of this lib are disabled.
   Changes to linuxnew/fs/jffs2 concerning free space calculation had been
   > super.c@85:
   > -       avail = c->dirty_size + c->free_size;
   > +       avail = (c->dirty_size / c->sector_size) * c->sector_size + c->free_size;
   and have been reverted.
*/

#ifdef __USE_FANCY_WRITE_METHODS__
#include <malloc.h> // for size_t

/* truncate modes */
typedef enum {
  NONE,               // don't truncate file, "r+" mode
  BEFORE_WRITE,       // truncate file to zero before writing, "w" mode
  RESERVED_LENGTH,    // truncate file to reserved length
  LAST_POS,           // truncate sequentially written file at current position
  MAX_POS,            // truncate file at greatest size position, 
                      //     written to since open
} pp_fa_truncate_mode_t;

/* FILE handle unaccessible to clients */
typedef struct fa_file_s PP_FA_FILE;

/* error handling */
int pp_fa_errno_base(void);

#define PP_FA_ERR_INIT_SEM      (pp_fa_errno_base() + 0)
#define PP_FA_ERR_ROOT_INVALID  (pp_fa_errno_base() + 1)
#define PP_FA_ERR_PATH_INVALID  (pp_fa_errno_base() + 2)

/**
 * opens a file for reading
 * access to file is locked, i.e. no one can read or write to file until it is
 * closed
 * perhaps we should allow multiple reads, but this may block pp_fopen_write()
 * calls
 * see fopen();
 */
//PP_FA_FILE *pp_fa_open_read(const char *filename);

/**
 * opens a file for writing
 * access to file is locked, i.e. no one can read or write to file until it is
 * closed
 * number of bytes to be reserved for reading have to be specified, -1 for no
 * reservation
 * returns NULL if flashdisk-space could not be reserved
 * see fopen();
 */
PP_FA_FILE *pp_fa_open_write(const char *filename, long reserve, 
                             pp_fa_truncate_mode_t truncate_mode);

/**
 * write to file
 * returns PP_ERR if number of bytes written exceedes reserved space
 * see fprintf(); ftell();
 */
//int pp_fa_printf(FILE *stream, const char *format, ...);

/**
 * write char pointer to file
 * see pp_fa_write();
 */
size_t pp_fa_print(PP_FA_FILE *fa_stream, const char *str);

/**
 * generic write to file
 * returns 0 if number of bytes written exceedes reserved space, return value
 * of fwrite() otherwhise
 * see fwrite();
 */
size_t pp_fa_write(PP_FA_FILE *fa_stream, const void *ptr, 
                   size_t size, size_t nitems);

/**
 * flushes stream
 * returns return value of fflush()
 * see fflush();
 */
//int pp_fa_flush(PP_FA_FILE *fa_stream);
 
/**
 * closes file
 * truncates file as requested from pp_fopen_write()
 * removes locks
 * see fclose(); ftruncate(); ?! how to truncate a stream?
 */
int pp_fa_close(PP_FA_FILE *fa_stream);

/* library management */
int  pp_fa_init(void);
void pp_fa_cleanup(void);
#endif /* __USE_FANCY_WRITE_METHODS__ */

/**
 * determines free space on flash (mounted at PP_FA_ROOT)
 * returns "real" free size if optimistic == 1
 * a more likely size (e.g. 75% of real) otherwhise
 */
long pp_fa_df(int optimistic);

/**
 * determines (recursively) the size of a file or directory
 * see busybox/du.c
 */
long pp_fa_du(const char *filename);

#endif /* _PP_FLASH_ACCESS_H */
