#include <stdio.h>
#include <pp/flash_access.h>
#include <pp/base.h>

static const char *teststring = "This is a 60 byte string char pointer with tailing newline\n";

int main(int argc, char **argv) {
    PP_FA_FILE *file;
    long size;
    pp_fa_truncate_mode_t truncate;
    
    if(argc != 4 || sscanf(argv[2], "%ld", &size) != 1)
        goto syntax;
    if(!strcmp(argv[3], "none"))
        truncate = NONE;
    else if(!strcmp(argv[3], "before_write"))
        truncate = BEFORE_WRITE;
    else if(!strcmp(argv[3], "reserved_length"))
        truncate = RESERVED_LENGTH;
    else if(!strcmp(argv[3], "last_pos"))
        truncate = LAST_POS;
    else if(!strcmp(argv[3], "max_pos"))
        truncate = MAX_POS;
    else 
        goto syntax;
    
    if(PP_ERR == pp_fa_init()) {
        printf("error initializing flash access lib: %s\n",
               pp_error_string(errno));
        return -1;
    }
    
    if((file = pp_fa_open_write(argv[1], size, truncate)) == NULL) {
        printf("error opening stream: %s\n", pp_error_string(errno));
        goto bail;
    }
    pp_fa_print(file, teststring);
while(pp_fa_print(file, teststring) > 0);
//while(1);
//char *foo; sprintf(foo, "create a segfault");
    pp_fa_print(file, teststring);
    pp_fa_close(file);

bail:
    pp_fa_cleanup();
    
    return 0;
    
 syntax:
    printf("\nSyntax %s filename reserve_size truncate_mode\n\n", argv[0]);
    printf("       reserve_size:  in bytes > 0\n");
    printf("       truncate_mode: none            - do not truncate file\n");
    printf("                      before_write    - truncate file to 0, then write\n");
    printf("                      reserved_length - truncate file to size reserved\n");
    printf("                      last_pos        - truncate file to position last written\n");
    printf("                      max_pos         - truncate file to maximum position written\n");
    printf("\nHappy hacking\n\n");
    return -1;
}
