/*****************************************************************************
* iipptr_bitmap.c                                                            *
*                                                                            *
* Copyright 2002 Peppercon AG                                                *
* Author: Thomas Rendelmann                                                  *
*                                                                            *
* Part of liberic_km                                                         *
* mouse driver iipps2 for Intelligent Mouse cursor Tracking                  *
*                                                                            *
* Contains functions for importing and exporting Windows Bitmap files (.BMP) *
* this module is not very flexible but this is not necessary here            *
*                                                                            *
* this is only needed for testing purposes !!                                *
*****************************************************************************/


#ifndef __IIPPTR_BITMAP_H

#define __IIPPTR_BITMAP_H

/* a 2D point */
typedef struct s_point {
	int pos_x;
	int pos_y;
} __attribute__((__packed__))  t_point;

/* RGB color value */
typedef struct s_rgb {
	unsigned short b;	/* blue */
	unsigned short g;	/* green */
	unsigned short r;	/* red */
} __attribute__((__packed__))  t_rgb;

/* HSV color value */
typedef struct s_hsv {
	unsigned short v;	/* value (intensity) */
	unsigned short s;	/* saturation */
	unsigned short h;	/* hue */
} __attribute__((__packed__))  t_hsv;

/* a bitmap */
typedef struct s_bitmap {
	unsigned int width;
	unsigned int height;
	t_rgb *rgb;		/* the color data */
} __attribute__((__packed__))  t_bitmap;

/* Bitmap file header */
typedef struct s_bitmap_file_header {
	unsigned short bf_type;
	unsigned int bf_size;
	unsigned short bf_reserved1;
	unsigned short bf_reserved2;
	unsigned int bf_off_bits;
} __attribute__((__packed__))  t_bitmap_file_header;

/* Bitmap info header */
typedef struct s_bitmap_info_header {
	unsigned int bi_size;
	unsigned int bi_width;
	unsigned int bi_height;
	unsigned short bi_planes;
	unsigned short bi_bitcount;
	unsigned int bi_compression;
	unsigned int bi_size_image;
	unsigned int bi_x_per_meter;
	unsigned int bi_y_per_meter;
	unsigned int bi_clr_used;
	unsigned int bi_clr_important;
} __attribute__((__packed__)) t_bitmap_info_header;

/* this function reads a bitmap file into a t_bitmap structure */
int read_bitmap(t_bitmap* bitmap, char* filename);

/* this function writes a t_bitmap structure into a bitmap file */
int write_bitmap(t_bitmap* bitmap, char *filename);

/* this function prints info and RGB values of the bitmap
   on the console */
int show_bitmap(t_bitmap * bitmap);

#endif /* __IIPPTR_BITMAP_H */
