#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <pp/hal_common.h>
#include <pp/features.h>
#include "flashid.h"

#define FLASH_FACTORY_ID_PATH	"/proc/mtd_prot_fact"
#define FLASH_USER_ID_PATH	"/proc/mtd_prot_user"
#define FLASH_ID_LOCK_PATH	"/proc/mtd_prot_lock"

static char * get_flash_id(const char * name);

char *
get_flash_factory_id(void)
{
    return get_flash_id(FLASH_FACTORY_ID_PATH);
}

char *
get_flash_user_id(void)
{
    return get_flash_id(FLASH_USER_ID_PATH);
}

char *
get_flash_user_id_lock(void)
{
    return get_flash_id(FLASH_ID_LOCK_PATH);
}

#ifdef PP_FEAT_CREATE_FLASHID

int
set_flash_user_id(const char * id)
{
    int fd, ret = PP_ERR;

    if ((fd = open(FLASH_USER_ID_PATH, O_WRONLY)) < 0) goto bail;
    if (write(fd, id, strlen(id)) != (ssize_t)strlen(id)) goto bail;
    ret = PP_SUC;

 bail:
    if (fd != -1) close(fd);
    return ret;
}

int
set_flash_user_id_lock(void)
{
    int fd, ret = PP_ERR;

    if ((fd = open(FLASH_ID_LOCK_PATH, O_WRONLY)) < 0) goto bail;
    if (write(fd, "1", 1) != 1) goto bail;
    ret = PP_SUC;

 bail:
    if (fd != -1) close(fd);
    return ret;
}

#endif /* PP_FEAT_CREATE_FLASHID */

static char *
get_flash_id(const char * name)
{
    char buf[PP_HAL_COMMON_MAX_FLASHID_LEN + 1];
    int fd, n;
    char* ret = NULL;
    
    if ((fd = open(name, O_RDONLY)) < 0) goto bail;
    if ((n = read(fd, buf, PP_HAL_COMMON_MAX_FLASHID_LEN)) < 0) goto bail;
    if (buf[n-1] == '\n') buf[n-1] = '\0';
    buf[n] = '\0';    
    ret = strdup(buf);
    
 bail:
    if (fd != -1) close(fd);
    return ret;
}
