#include <getopt.h>
#include <pp/base.h>
#include <pp/hal.h>
#include <pp/hal_icpmmd.h>

void
usage(void)
{
    fprintf(stderr, "Usage: icpmmd_test -f <function> -n <node> [ -d <delay in ms> ]\n");
}

int
main(int argc, char ** argv)
{
    int c, error;
    u_int fflag = 0, nflag = 0;
    u_int function = 0, delay_ms = 200, node = 0;

    opterr = 0;
     
    while ((c = getopt (argc, argv, "f:d:n:")) != -1) {
	switch (c) {
	  case 'f':
	      function = pp_strtoul_10(optarg, 0, &error);
	      if (error) {
		  fprintf(stderr, "%s: Option -f requires an unsigned integer argument.\n", argv[0]);
		  return 1;
	      }
	      fflag = 1;
	      break;
	  case 'd':
	      delay_ms = pp_strtoul_10(optarg, 0, &error);
	      if (error) {
		  fprintf(stderr, "%s: Option -d requires an unsigned integer argument.\n", argv[0]);
		  return 1;
	      }
	      break;
	  case 'n':
	      node = pp_strtoul_10(optarg, 0, &error);
	      if (error) {
		  fprintf(stderr, "%s: Option -n requires an unsigned integer argument.\n", argv[0]);
		  return 1;
	      }
	      nflag = 1;
	      break;
	  case '?':
	      if (isprint(optopt)) {
		  fprintf(stderr, "%s: Unknown option `-%c'.\n", argv[0], optopt);
	      } else {
		  fprintf(stderr, "%s: Unknown option character `\\x%x'.\n", argv[0], optopt);
	      }
	      return 1;
	  default:
	      usage();
	      return 1;
	}
    }

    if (!fflag || !nflag) {
	usage();
	return 1;
    }

    if (PP_FAILED(pp_base_init("icpmmd_test", LOG_NOT_SILENT))) {
	pp_log("Initializing base-library failed.\n");
	return 1;
    }

    pp_hal_icpmmd_switch(function, node, delay_ms, 0);

    pp_base_cleanup();

    return 0;
}
