#ifndef _PP_HAL_ICPMMD_H
#define _PP_HAL_ICPMMD_H

typedef enum {
    ICPMMD_SWITCH_TYPE_KVM = 0,
    ICPMMD_SWITCH_TYPE_BMC_RESET = 2,
    ICPMMD_SWITCH_TYPE_POWER = 3,
    ICPMMD_SWITCH_TYPE_RESET = 4,
} icpmmd_switch_type_t;

int pp_hal_icpmmd_switch_kvm(u_int node);
int pp_hal_icpmmd_reset_bmc(u_int node);
int pp_hal_icpmmd_power_blade(u_int node, u_int delay_ms, int non_block);
int pp_hal_icpmmd_reset_blade(u_int node, u_int delay_ms, int non_block);
int pp_hal_icpmmd_switch(icpmmd_switch_type_t switch_type, u_int node,
			 u_int delay_ms, int non_block);
int pp_hal_icpmmd_get_selected_blade(unsigned char* sel_node_copy);

#endif /* _PP_HAL_ICPMMD_H */
