#ifndef __HAL_RPC_H__
#define __HAL_RPC_H__

typedef enum {
    RELAIS_BOARD_CONTROLLER_UNDEF,
    RELAIS_BOARD_CONTROLLER_4,
    RELAIS_BOARD_CONTROLLER_5,
    RELAIS_BOARD_CONTROLLER_5_3
} pp_hal_rpc_relais_board_controller_t;

typedef struct {
    const char*                                 model;
    int                                         no_outlets;
    int                                         no_rows;
    int                                         no_outlets_per_board;
    pp_hal_rpc_relais_board_controller_t        controller;
    int                                         curr_max;
    int                                         curr_max_board;
    const char*                                 topo;
} pp_hal_rpc_model_t;

extern pp_hal_rpc_model_t pp_hal_rpc_models[];
extern int pp_hal_rpc_models_sz;

int pp_hal_rpc_model_idx_by_name(const char* mname);

/* use pp_hal_rpc_get API to get information about currently configured RPC
   _NOTE_ you have to reboot after switching model type */
const char* pp_hal_rpc_get_model(void);
int pp_hal_rpc_get_no_outlets(void);
int pp_hal_rpc_get_no_rows(void);
int pp_hal_rpc_get_no_outlets_per_board(void);
pp_hal_rpc_relais_board_controller_t pp_hal_rpc_get_controller(void);
int pp_hal_rpc_get_curr_max(void);
int pp_hal_rpc_get_curr_max_board(void);
const char* pp_hal_rpc_get_topo(void);

#endif /* __HAL_RPC_H__ */
