#ifndef _HAL_KX2_H
#define _HAL_KX2_H

#define KX2_PCF8574_I2C_ADDR 0x20

#define KX2_POWER_LED_BLUE 0x1
#define KX2_POWER_LED_RED  0x2
#define KX2_DUAL_POWER_1   0x4
#define KX2_DUAL_POWER_2   0x8

#define KX2_DUAL_POWER_MASK 0xc

#define KX2_USER_LED_1	    0x80
#define KX2_USER_LED_2	    0x40
#define KX2_USER_LED_3	    0x20
#define KX2_USER_LED_4	    0x10

#define RARITAN_HWID_MODEL_MASK 0xc
#define RARITAN_HWID_MODEL_SHIFT 2

#define RARITAN_HWID_MODEL_KX432 0x0
#define RARITAN_HWID_MODEL_KX416 0x1
#define RARITAN_HWID_MODEL_KX232 0x2
#define RARITAN_HWID_MODEL_KX216 0x3
#define RARITAN_HWID_MODEL_KX132 0x4
#define RARITAN_HWID_MODEL_KX116 0x5
#define RARITAN_HWID_MODEL_KX464 0x6


void pcf8574_cleanup(void);
int pcf8574_init(void);

//! Terminate power supply monitor thread gracefully.
void power_supply_monitor_thread_clean(void);

#endif /* _HAL_KX2_H */
