#include <sys/types.h>
#include <pp/i2c.h>
#include <pp/hal_kx2.h>
#include <pp/base.h>
#include <liberic_notify.h>
#include "kx2/kx2.h"
#include <pp/cfg.h>

static pthread_t g_powersupply_thread=0;
static int thread_exit=0;
//! forward declaration : just used internall shouldnt be accessed from anywhere else
void *monitor_power_supply( void *ptr );

// interrupts not working hence pull the status and notify
void *monitor_power_supply( void *ptr ) {
    int nFailedOutlet =0; 
//	int nPSCount = 2 ;
    int ps1_detect = 1 ; // get it from Cfg
    int ps2_detect = 1 ; // get it from Cfg	
    int notify = 1;
    ptr = NULL;
    
    while(1) {
	if ( thread_exit ) break;
	nFailedOutlet = pp_hal_kx2_get_power_status();
	//              pp_cfg_get_uint(&nPSCount, "power_supply._s_");

	if ( PP_ERR == pp_cfg_is_enabled(&ps1_detect, "power_supply.autodetect[0].status")){
	    ps1_detect =1 ; // default is detect
	}

	if ( PP_ERR == pp_cfg_is_enabled(&ps2_detect, "power_supply.autodetect[1].status")){
	    ps2_detect =1 ; // default is detect
	}

	if ((( nFailedOutlet == PP_HAL_KX2_DUAL_POWER_1 ) && ( ps1_detect ) ) || (( nFailedOutlet == PP_HAL_KX2_DUAL_POWER_2 ) && ( ps2_detect ) ) ) {
	    pp_hal_kx2_set_power_led(0,1); // red
	    if ( notify )
	    {
		//Send appro event/notification to GUIs
		eric_notify_power_supply_change( nFailedOutlet );
		notify = 0;
	    }
	}
	else {
	    pp_hal_kx2_set_power_led(1,0); // blue
	    notify=1;
	}
	sleep(1);
    }// end while 1
    return NULL;
}

int pp_hal_power_supply_monitor_thread_start() { //start it at boot. since power-supply-auto-detect is true by default. 
    int nRet = 0;
    nRet = pthread_create( &g_powersupply_thread, NULL, monitor_power_supply, NULL);      
    return nRet;
}

void power_supply_monitor_thread_clean() { 
    printf("\nDestroying power_supply_monitor_thread [%d]\n",(int)pthread_self());
    thread_exit = 1;
    pthread_join(g_powersupply_thread , NULL);
}
