/**
 * Wrapper for libintl use in erla firmware
 *
 * Author: Thomas Rendelmann <thre@peppercon.de>
 * Copyright 2003 Peppercon AG
 */

#ifndef _PP_INTL_H
#define _PP_INTL_H

/* no translations for PEMX/PSETUP/kiratool for the time beeing, just make it compile */
#if defined(PP_BOARD_PEMX) || defined(PP_BOARD_PSETUP) || defined (PP_FW_TYPE_KIRATOOL)

#define _(string)  string
#define N_(string) string

#else /* !PP_BOARD_PEMX && !PP_BOARD_PSETUP && !PP_FW_TYPE_KIRATOOL */

#include <libintl.h>

#define PP_INTL_DEFAULT_LANGUAGE	"en"

/* initialize and cleanup the library */
int pp_intl_init(void);
void pp_intl_cleanup(void);

/* set a new language for the interface */
void pp_intl_set_language(const char * language);

/* get the current language setting */
const char * pp_intl_get_language_shortname(void);
const char * pp_intl_get_language_fullname(void);

/* marking the strings in the source code */
static inline const char * _(const char * s)
{
	return (s && *s != '\0') ? gettext(s) : s;
}
#define N_(string)	string

/* translate strings */
const char * pp_intl_translate(const char * s);

/* get all available translations by index
   (these are the ones we have a translation file for and we can use as translation) */
int pp_intl_get_no_translations(void);
const char * pp_intl_get_translation_shortname(int no);
const char * pp_intl_get_translation_fullname(int no);
const char * pp_intl_get_translation_utf8name(int no);

/* get all possible languages by index
   (these are all languages we might support if we had a language file) */
int pp_intl_get_no_possible_languages(void);
const char * pp_intl_get_possible_language_shortname(int no);
const char * pp_intl_get_possible_language_fullname(int no);
const char * pp_intl_get_possible_language_utf8name(int no);


/* get the character set of the currently set language */
const char * pp_intl_get_charset(void);

/* get the corresponding full/utf8 name from a short name (according to ISO 639-1) */
const char *pp_intl_get_fullname_from_shortname(const char *shortname);
const char *pp_intl_get_utf8name_from_shortname(const char *shortname);

#endif /* !PP_BOARD_PEMX && !PP_BOARD_PSETUP */

#endif /* _PP_INTL_H */
