#include <stdio.h>
#include <string.h>

#include <pp/intl.h>

#include "language.h"

t_language languages[] = {
    { "aa",	N_("Afar"), "Afaraf" },
    { "ab",	N_("Abkhazian"),
        { 0xD0, 0x90, 0xD2, 0xA7, 0xD1, 0x81, 0xD1, 0x83, 0xD0, 0xB0, 0x00 } },
    { "ae",	N_("Avestan"), "avesta" },
    { "af",	N_("Afrikaans"), "Afrikaans" },
    { "ak",	N_("Akan"), "Akan" },
    { "am",	N_("Amharic"),
        { 0xE1, 0x8A, 0xA0, 0xE1, 0x88, 0x9B, 0xE1, 0x88, 0xAD, 0xE1, 0x8A, 0x9B,
          0x00 } },
    { "an",	N_("Aragonese"),
        { 0x41, 0x72, 0x61, 0x67, 0x6F, 0x6E, 0xC3, 0xA9, 0x73, 0x00 } },
    { "ar",	N_("Arabic"),
        { 0xE2, 0x80, 0xAB, 0xD8, 0xA7, 0xD9, 0x84, 0xD8, 0xB9, 0xD8, 0xB1, 0xD8,
          0xA8, 0xD9, 0x8A, 0xD8, 0xA9, 0x00 } },
    { "as",	N_("Assamese"),
        { 0xE0, 0xA6, 0x85, 0xE0, 0xA6, 0xB8, 0xE0, 0xA6, 0xAE, 0xE0, 0xA7, 0x80,
          0xE0, 0xA6, 0xAF, 0xE0, 0xA6, 0xBC, 0xE0, 0xA6, 0xBE, 0x00 } },
    { "av",	N_("Avaric"),
        { 0xD0, 0xB0, 0xD0, 0xB2, 0xD0, 0xB0, 0xD1, 0x80, 0x20, 0xD0, 0xBC, 0xD0,
          0xB0, 0xD1, 0x86, 0xD3, 0x80, 0x00 } },
    { "ay",	N_("Aymara"), "aymar aru" },
    { "az",	N_("Azerbaijani"), 
        { 0x61, 0x7A, 0xC9, 0x99, 0x72, 0x62, 0x61, 0x79, 0x63, 0x61, 0x6E, 0x20,
          0x64, 0x69, 0x6C, 0x69, 0x00 } },
    { "ba",	N_("Bashkir"), 
	{ 0xD0, 0xB1, 0xD0, 0xB0, 0xD1, 0x88, 0xD2, 0xA1, 0xD0, 0xBE, 0xD1, 0x80,
	  0xD1, 0x82, 0x20, 0xD1, 0x82, 0xD0, 0xB5, 0xD0, 0xBB, 0xD0, 0xB5, 0x00 } },
    { "be",	N_("Belarusian"), 
	{ 0xD0, 0x91, 0xD0, 0xB5, 0xD0, 0xBB, 0xD0, 0xB0, 0xD1, 0x80, 0xD1, 0x83,
	  0xD1, 0x81, 0xD0, 0xBA, 0xD0, 0xB0, 0xD1, 0x8F, 0x00 } },
    { "bg",	N_("Bulgarian"), 
	{ 0xD0, 0xB1, 0xD1, 0x8A, 0xD0, 0xBB, 0xD0, 0xB3, 0xD0, 0xB0, 0xD1, 0x80,
	  0xD1, 0x81, 0xD0, 0xBA, 0xD0, 0xB8, 0x20, 0xD0, 0xB5, 0xD0, 0xB7, 0xD0,
	  0xB8, 0xD0, 0xBA, 0x00 } },
    { "bh",	N_("Bihari"), 
	{ 0xE0, 0xA4, 0xAD, 0xE0, 0xA5, 0x8B, 0xE0, 0xA4, 0x9C, 0xE0, 0xA4, 0xAA,
	  0xE0, 0xA5, 0x81, 0xE0, 0xA4, 0xB0, 0xE0, 0xA5, 0x80, 0x00 } },
    { "bi",	N_("Bislama"), "Bislama" },
    { "bm",	N_("Bambara"), "bamanankan" },
    { "bn",	N_("Bengali"), 
	{ 0xE0, 0xA6, 0xAC, 0xE0, 0xA6, 0xBE, 0xE0, 0xA6, 0x82, 0xE0, 0xA6, 0xB2,
	  0xE0, 0xA6, 0xBE, 0x00 } },
    { "bo",	N_("Tibetan"),
	{ 0xE0, 0xBD, 0x96, 0xE0, 0xBD, 0xBC, 0xE0, 0xBD, 0x91, 0xE0, 0xBC, 0x8B,
	  0xE0, 0xBD, 0xA1, 0xE0, 0xBD, 0xB2, 0xE0, 0xBD, 0x82, 0x00 } },
    { "br",	N_("Breton"), "brezhoneg" },
    { "bs",	N_("Bosnian"), "bosanski jezik" },
    { "ca",	N_("Catalan"), 
	{ 0x43, 0x61, 0x74, 0x61, 0x6C, 0xC3, 0xA0, 0x00 } },
    { "ce",	N_("Chechen"), 
	{ 0xD0, 0xBD, 0xD0, 0xBE, 0xD1, 0x85, 0xD1, 0x87, 0xD0, 0xB8, 0xD0, 0xB9,
	  0xD0, 0xBD, 0x20, 0xD0, 0xBC, 0xD0, 0xBE, 0xD1, 0x82, 0xD1, 0x82, 0x00 } },
    { "ch",	N_("Chamorro"), "Chamoru" },
    { "co",	N_("Corsican"), "corsu" },
    { "cr",	N_("Cree"),
	{ 0xE1, 0x93, 0x80, 0xE1, 0x90, 0xA6, 0xE1, 0x90, 0x83, 0xE1, 0x94, 0xAD,
	  0xE1, 0x90, 0x8D, 0xE1, 0x90, 0x8F, 0xE1, 0x90, 0xA3, 0x00 } },
    { "cs",	N_("Czech"),
	{ 0xC4, 0x8D, 0x65, 0x73, 0x6B, 0x79, 0x00 } },
    { "cu",	N_("Church Slavic"), "" },
    { "cv",	N_("Chuvash"),
	{ 0xD1, 0x87, 0xD3, 0x91, 0xD0, 0xB2, 0xD0, 0xB0, 0xD1, 0x88, 0x20, 0xD1,
	  0x87, 0xD3, 0x97, 0xD0, 0xBB, 0xD1, 0x85, 0xD0, 0xB8, 0x00 } },
    { "cy",	N_("Welsh"), "Cymraeg" },
    { "da",	N_("Danish"), "dansk" },
    { "de",	N_("German"), "Deutsch" },
    { "dv",	N_("Divehi"),
	{ 0xE2, 0x80, 0xAB, 0xDE, 0x8B, 0xDE, 0xA8, 0xDE, 0x88, 0xDE, 0xAC, 0xDE,
	  0x80, 0xDE, 0xA8, 0x00 } },
    { "dz",	N_("Dzongkha"),
	{ 0xE0, 0xBD, 0xA2, 0xE0, 0xBE, 0xAB, 0xE0, 0xBD, 0xBC, 0xE0, 0xBD, 0x84,
	  0xE0, 0xBC, 0x8B, 0xE0, 0xBD, 0x81, 0x00 } },
    { "ee",	N_("Ewe"),
	{ 0xC6, 0x90, 0xCA, 0x8B, 0xC9, 0x9B, 0x67, 0x62, 0xC9, 0x9B, 0x00 } },
    { "el",	N_("Greek"),
	{ 0xCE, 0x95, 0xCE, 0xBB, 0xCE, 0xBB, 0xCE, 0xB7, 0xCE, 0xBD, 0xCE,
	  0xB9, 0xCE, 0xBA, 0xCE, 0xAC, 0x00 } },
    { "en",	N_("English"), "English" },
    { "eo",	N_("Esperanto"), "Esperanto" },
    { "es",	N_("Spanish"),
	{ 0x65, 0x73, 0x70, 0x61, 0xC3, 0xB1, 0x6F, 0x6C, 0x00 } },
    { "et",	N_("Estonian"), "Eesti keel" },
    { "eu",	N_("Basque"), "euskara" },
    { "fa",	N_("Persian"),
	{ 0xE2, 0x80, 0xAB, 0xD9, 0x81, 0xD8, 0xA7, 0xD8, 0xB1, 0xD8, 0xB3, 0xDB,
	  0x8C, 0x00 } },
    { "ff",	N_("Fulah"), "Fulfulde" },
    { "fi",	N_("Finnish"), "suomen kieli" },
    { "fj",	N_("Fijian"), "vosa Vakaviti" },
    { "fo",	N_("Faroese"),
	{ 0x46, 0xC3, 0xB8, 0x72, 0x6F, 0x79, 0x73, 0x6B, 0x74, 0x00 } },
    { "fr",	N_("French"),
	{ 0x66, 0x72, 0x61, 0x6E, 0xC3, 0xA7, 0x61, 0x69, 0x73, 0x00 } },
    { "fy",	N_("Western Frisian"), "Frysk" },
    { "ga",	N_("Irish"), "Gaeilge" },
    { "gd",	N_("Scottish Gaelic"),
	{ 0x47, 0xC3, 0xA0, 0x69, 0x64, 0x68, 0x6C, 0x69, 0x67, 0x00 } },
    { "gl",	N_("Galician"), "Galego" },
    { "gn",	N_("Guarani"),
	{ 0x41, 0x76, 0x61, 0xC3, 0xB1, 0x65, 0x27, 0xE1, 0xBA, 0xBD, 0x00 } },
    { "gu",	N_("Gujarati"),
	{ 0xE0, 0xAA, 0x97, 0xE0, 0xAB, 0x81, 0xE0, 0xAA, 0x9C, 0xE0, 0xAA, 0xB0,
	  0xE0, 0xAA, 0xBE, 0xE0, 0xAA, 0xA4, 0xE0, 0xAB, 0x80, 0x00 } },
    { "gv",	N_("Manx"), "Ghaelg" },
    { "ha",	N_("Hausa"),
	{ 0xE2, 0x80, 0xAB, 0xD9, 0x87, 0xD9, 0x8E, 0xD9, 0x88, 0xD9, 0x8F, 0xD8,
	  0xB3, 0xD9, 0x8E, 0x00 } },
    { "he",	N_("Hebrew"),
	{ 0xE2, 0x80, 0xAB, 0xD7, 0xA2, 0xD7, 0x91, 0xD7, 0xA8, 0xD7, 0x99, 0xD7,
	  0xAA, 0x00 } },
    { "hi",	N_("Hindi"),
	{ 0xE0, 0xA4, 0xB9, 0xE0, 0xA4, 0xBF, 0xE0, 0xA4, 0xA8, 0xE0, 0xA5, 0x8D,
	  0xE0, 0xA4, 0xA6, 0xE0, 0xA5, 0x80, 0x00 } },
    { "ho",	N_("Hiri Motu"), "Hiri Motu" },
    { "hr",	N_("Croatian"), "Hrvatski" },
    { "ht",	N_("Haitian"),
	{ 0x4B, 0x72, 0x65, 0x79, 0xC3, 0xB2, 0x6C, 0x20, 0x61, 0x79, 0x69, 0x73,
	  0x79, 0x65, 0x6E, 0x00 } },
    { "hu",	N_("Hungarian"), "Magyar" },
    { "hy",	N_("Armenian"),
	{ 0xD5, 0x80, 0xD5, 0xA1, 0xD5, 0xB5, 0xD5, 0xA5, 0xD6, 0x80, 0xD5, 0xA5,
	  0xD5, 0xB6, 0x00 } },
    { "hz",	N_("Herero"), "Otjiherero" },
    { "ia",	N_("Interlingua"), "interlingua" },
    { "id",	N_("Indonesian"), "Bahasa Indonesia" },
    { "ie",	N_("Interlingue"), "Interlingue" },
    { "ig",	N_("Igbo"), "Igbo" },
    { "ii",	N_("Sichuan Yi"),
	{ 0xEA, 0x86, 0x87, 0xEA, 0x89, 0x99, 0x00 } },
    { "ik",	N_("Inupiaq"),
	{ 0x49, 0xC3, 0xB1, 0x75, 0x70, 0x69, 0x61, 0x71, 0x00 } },
    { "io",	N_("Ido"), "Ido" },
    { "is",	N_("Icelandic"),
	{ 0xC3, 0x8D, 0x73, 0x6C, 0x65, 0x6E, 0x73, 0x6B, 0x61, 0x00 } },
    { "it",	N_("Italian"), "Italiano" },
    { "iu",	N_("Inuktitut"),
	{ 0xE1, 0x90, 0x83, 0xE1, 0x93, 0x84, 0xE1, 0x92, 0x83, 0xE1, 0x91, 0x8E,
	  0xE1, 0x91, 0x90, 0xE1, 0x91, 0xA6, 0x00 } },
    { "ja",	N_("Japanese"),
	{ 0xE6, 0x97, 0xA5, 0xE6, 0x9C, 0xAC, 0xE8, 0xAA, 0x9E, 0x00 } },
    { "jv",	N_("Javanese"), "basa Jawa" },
    { "ka",	N_("Georgian"),
	{ 0xE1, 0x83, 0xA5, 0xE1, 0x83, 0x90, 0xE1, 0x83, 0xA0, 0xE1, 0x83, 0x97,
	  0xE1, 0x83, 0xA3, 0xE1, 0x83, 0x9A, 0xE1, 0x83, 0x98, 0x00 } },
    { "kg",	N_("Kongo"), "KiKongo" },
    { "ki",	N_("Kikuyu"),
	{ 0x47, 0xC4, 0xA9, 0x6B, 0xC5, 0xA9, 0x79, 0xC5, 0xA9, 0x00 } },
    { "kj",	N_("Kuanyama"), "Kuanyama" },
    { "kk",	N_("Kazakh"),
	{ 0xD2, 0x9A, 0xD0, 0xB0, 0xD0, 0xB7, 0xD0, 0xB0, 0xD2, 0x9B, 0x20, 0xD1,
	  0x82, 0xD1, 0x96, 0xD0, 0xBB, 0xD1, 0x96, 0x00 } },
    { "kl",	N_("Kalaallisut"), "kalaallisut" },
    { "km",	N_("Khmer"),
	{ 0xE1, 0x9E, 0x97, 0xE1, 0x9E, 0xB6, 0xE1, 0x9E, 0x9F, 0xE1, 0x9E, 0xB6,
	  0xE1, 0x9E, 0x81, 0xE1, 0x9F, 0x92, 0xE1, 0x9E, 0x98, 0xE1, 0x9F, 0x82,
	  0xE1, 0x9E, 0x9A, 0x00 } },
    { "kn",	N_("Kannada"),
	{ 0xE0, 0xB2, 0x95, 0xE0, 0xB2, 0xA8, 0xE0, 0xB3, 0x8D, 0xE0, 0xB2, 0xA8,
	  0xE0, 0xB2, 0xA1, 0x00 } },
    { "ko",	N_("Korean"),
	{ 0xED, 0x95, 0x9C, 0xEA, 0xB5, 0xAD, 0xEC, 0x96, 0xB4, 0x00 } },
    { "kr",	N_("Kanuri"), "Kanuri" },
    { "ks",	N_("Kashmiri"), 
	{ 0xE0, 0xA4, 0x95, 0xE0, 0xA4, 0xB6, 0xE0, 0xA5, 0x8D, 0xE0, 0xA4, 0xAE,
	  0xE0, 0xA5, 0x80, 0xE0, 0xA4, 0xB0, 0xE0, 0xA5, 0x80, 0x00 } },
    { "ku",	N_("Kurdish"),
	{ 0x4B, 0x75, 0x72, 0x64, 0xC3, 0xAE, 0x00 } },
    { "kv",	N_("Komi"),
	{ 0xD0, 0xBA, 0xD0, 0xBE, 0xD0, 0xBC, 0xD0, 0xB8, 0x20, 0xD0, 0xBA, 0xD1,
	  0x8B, 0xD0, 0xB2, 0x00 } },
    { "kw",	N_("Cornish"), "Kernewek" },
    { "ky",	N_("Kirghiz"),
	{ 0xD0, 0xBA, 0xD1, 0x8B, 0xD1, 0x80, 0xD0, 0xB3, 0xD1, 0x8B, 0xD0, 0xB7,
	  0x20, 0xD1, 0x82, 0xD0, 0xB8, 0xD0, 0xBB, 0xD0, 0xB8, 0x00 } },
    { "la",	N_("Latin"), "latine" },
    { "lb",	N_("Luxembourgish"),
	{ 0x4C, 0xC3, 0xAB, 0x74, 0x7A, 0x65, 0x62, 0x75, 0x65, 0x72, 0x67, 0x65,
	  0x73, 0x63, 0x68, 0x00 } },
    { "lg",	N_("Ganda"), "Luganda" },
    { "li",	N_("Limburgish"), "Limburgs" },
    { "ln",	N_("Lingala"),
	{ 0x4C, 0x69, 0x6E, 0x67, 0xC3, 0xA1, 0x6C, 0x61, 0x00 } },
    { "lo",	N_("Lao"),
	{ 0xE0, 0xBA, 0x9E, 0xE0, 0xBA, 0xB2, 0xE0, 0xBA, 0xAA, 0xE0, 0xBA, 0xB2,
	  0xE0, 0xBA, 0xA5, 0xE0, 0xBA, 0xB2, 0xE0, 0xBA, 0xA7, 0x00 } },
    { "lt",	N_("Lithuanian"),
	{ 0x6C, 0x69, 0x65, 0x74, 0x75, 0x76, 0x69, 0xC5, 0xB3, 0x20, 0x6B, 0x61,
	  0x6C, 0x62, 0x61, 0x00 } },
    { "lu",	N_("Luba-Katanga"), "" },
    { "lv",	N_("Latvian"),
	{ 0x6C, 0x61, 0x74, 0x76, 0x69, 0x65, 0xC5, 0xA1, 0x75, 0x20, 0x76, 0x61,
	  0x6C, 0x6F, 0x64, 0x61, 0x00 } },
    { "mg",	N_("Malagasy"), "Malagasy fiteny" },
    { "mh",	N_("Marshallese"),
	{ 0x4B, 0x61, 0x6A, 0x69, 0x6E, 0x20, 0x4D, 0xCC, 0xA7, 0x61, 0x6A, 0x65,
	  0xC4, 0xBC, 0x00 } },
    { "mi",	N_("Maori"),
	{ 0x74, 0x65, 0x20, 0x72, 0x65, 0x6F, 0x20, 0x4D, 0xC4, 0x81, 0x6F, 0x72,
	  0x69, 0x00 } },
    { "mk",	N_("Macedonian"),
	{ 0xD0, 0xBC, 0xD0, 0xB0, 0xD0, 0xBA, 0xD0, 0xB5, 0xD0, 0xB4, 0xD0, 0xBE,
	  0xD0, 0xBD, 0xD1, 0x81, 0xD0, 0xBA, 0xD0, 0xB8, 0x20, 0xD1, 0x98, 0xD0,
	  0xB0, 0xD0, 0xB7, 0xD0, 0xB8, 0xD0, 0xBA, 0x00 } },
    { "ml",	N_("Malayalam"),
	{ 0xE0, 0xB4, 0xAE, 0xE0, 0xB4, 0xB2, 0xE0, 0xB4, 0xAF, 0xE0, 0xB4, 0xBE,
	  0xE0, 0xB4, 0xB3, 0xE0, 0xB4, 0x82 } },
    { "mn",	N_("Mongolian"),
	{ 0xD0, 0x9C, 0xD0, 0xBE, 0xD0, 0xBD, 0xD0, 0xB3, 0xD0, 0xBE, 0xD0, 0xBB,
	  0x00 } },
    { "mo",	N_("Moldavian"),
	{ 0xD0, 0xBB, 0xD0, 0xB8, 0xD0, 0xBC, 0xD0, 0xB1, 0xD0, 0xB0, 0x20, 0xD0,
	  0xBC, 0xD0, 0xBE, 0xD0, 0xBB, 0xD0, 0xB4, 0xD0, 0xBE, 0xD0, 0xB2, 0xD0,
	  0xB5, 0xD0, 0xBD, 0xD1, 0x8F, 0xD1, 0x81, 0xD0, 0xBA, 0xD1, 0x8D, 0x00 } },
    { "mr",	N_("Marathi"), 
	{ 0xE0, 0xA4, 0xAE, 0xE0, 0xA4, 0xB0, 0xE0, 0xA4, 0xBE, 0xE0, 0xA4, 0xA0,
	  0xE0, 0xA5, 0x80, 0x00 } },
    { "ms",	N_("Malay"), "bahasa Melayu" },
    { "mt",	N_("Maltese"), "Malti" },
    { "my",	N_("Burmese"),
	{ 0xE1, 0x80, 0x97, 0xE1, 0x80, 0x99, 0xE1, 0x80, 0xAC, 0xE1, 0x80, 0x85,
	  0xE1, 0x80, 0xAC, 0x00 } },
    { "na",	N_("Nauru"),
	{ 0x45, 0x6B, 0x61, 0x6B, 0x61, 0x69, 0x72, 0xC5, 0xA9, 0x20, 0x4E, 0x61,
	  0x6F, 0x65, 0x72, 0x6F, 0x00 } },
    { "nb",	N_("Norwegian Bokmal"),
	{ 0x4E, 0x6F, 0x72, 0x73, 0x6B, 0x20, 0x62, 0x6F, 0x6B, 0x6D, 0xC3, 0xA5,
	  0x6C, 0x00 } },
    { "nd",	N_("North Ndebele"), "isiNdebele" },
    { "ne",	N_("Nepali"),
	{ 0xE0, 0xA4, 0xA8, 0xE0, 0xA5, 0x87, 0xE0, 0xA4, 0xAA, 0xE0, 0xA4, 0xBE,
	  0xE0, 0xA4, 0xB2, 0xE0, 0xA5, 0x80, 0x00 } },
    { "ng",	N_("Ndonga"), "Owambo" },
    { "nl",	N_("Dutch"), "Nederlands" },
    { "nn",	N_("Norwegian Nynorsk"), "Norsk nynorsk" },
    { "no",	N_("Norwegian"), "Norsk" },
    { "nr",	N_("South Ndebele"),
	{ 0x4E, 0x64, 0xC3, 0xA9, 0x62, 0xC3, 0xA9, 0x6C, 0xC3, 0xA9, 0x00 } },
    { "nv",	N_("Navajo"),
	{ 0x44, 0x69, 0x6E, 0xC3, 0xA9, 0x20, 0x62, 0x69, 0x7A, 0x61, 0x61, 0x64,
	  0x00 } },
    { "ny",	N_("Chichewa"),
	{ 0x63, 0x68, 0x69, 0x43, 0x68, 0x65, 0xC5, 0xB5, 0x61, 0x00 } },
    { "oc",	N_("Occitan"), "Occitan" },
    { "oj",	N_("Ojibwa"),
	{ 0xE1, 0x90, 0x8A, 0xE1, 0x93, 0x82, 0xE1, 0x94, 0x91, 0xE1, 0x93, 0x88,
	  0xE1, 0x90, 0xAF, 0xE1, 0x92, 0xA7, 0xE1, 0x90, 0x8E, 0xE1, 0x93, 0x90,
	  0x00 } },
    { "om",	N_("Oromo"), "Afaan Oromoo" },
    { "or",	N_("Oriya"),
	{ 0xE0, 0xAC, 0x93, 0xE0, 0xAC, 0xA1, 0xE0, 0xAC, 0xBC, 0xE0, 0xAC, 0xBF,
	  0xE0, 0xAC, 0x86, 0x00 } },
    { "os",	N_("Ossetian"),
	{ 0xD0, 0x98, 0xD1, 0x80, 0xD0, 0xBE, 0xD0, 0xBD, 0x20, 0xC3, 0xA6, 0xD0,
	  0xB2, 0xD0, 0xB7, 0xD0, 0xB0, 0xD0, 0xB3, 0x00 } },
    { "pa",	N_("Panjabi"),
	{ 0xE0, 0xA8, 0xAA, 0xE0, 0xA9, 0xB0, 0xE0, 0xA8, 0x9C, 0xE0, 0xA8, 0xBE,
	  0xE0, 0xA8, 0xAC, 0xE0, 0xA9, 0x80, 0x00 } },
    { "pi",	N_("Pali"),
	{ 0xE0, 0xA4, 0xAA, 0xE0, 0xA4, 0xBE, 0xE0, 0xA4, 0xBF, 0xE0, 0xA4, 0xB4,
	  0x00 } },
    { "pl",	N_("Polish"), "polski" },
    { "ps",	N_("Pashto"), 
	{ 0xE2, 0x80, 0xAB, 0xD9, 0xBE, 0xDA, 0x9A, 0xD8, 0xAA, 0xD9, 0x88, 0x00 } },
    { "pt",	N_("Portuguese"),
	{ 0x50, 0x6F, 0x72, 0x74, 0x75, 0x67, 0x75, 0xC3, 0xAA, 0x73, 0x00 } },
    { "qu",	N_("Quechua"), "Runa Simi" },
    { "rm",	N_("Raeto-Romance"), "rumantsch grischun" },
    { "rn",	N_("Kirundi"), "kiRundi" },
    { "ro",	N_("Romanian"),
	{ 0x72, 0x6F, 0x6D, 0xC3, 0xA2, 0x6E, 0xC4, 0x83, 0x00 } },
    { "ru",	N_("Russian"),
	{ 0xD1, 0x80, 0xD1, 0x83, 0xD1, 0x81, 0xD1, 0x81, 0xD0, 0xBA, 0xD0, 0xB8,
	  0xD0, 0xB9, 0x20, 0xD1, 0x8F, 0xD0, 0xB7, 0xD1, 0x8B, 0xD0, 0xBA, 0x00 } },
    { "rw",	N_("Kinyarwanda"), "Kinyarwanda" },
    { "sa",	N_("Sanskrit"),
	{ 0xE0, 0xA4, 0xB8, 0xE0, 0xA4, 0x82, 0xE0, 0xA4, 0xB8, 0xE0, 0xA5, 0x8D,
	  0xE0, 0xA4, 0x95, 0xE0, 0xA5, 0x83, 0xE0, 0xA4, 0xA4, 0xE0, 0xA4, 0xAE,
	  0xE0, 0xA5, 0x8D, 0x00 } },
    { "sc",	N_("Sardinian"), "sardu" },
    { "sd",	N_("Sindhi"),
	{ 0xE0, 0xA4, 0xB8, 0xE0, 0xA4, 0xBF, 0xE0, 0xA4, 0xA8, 0xE0, 0xA5, 0x8D,
	  0xE0, 0xA4, 0xA7, 0xE0, 0xA5, 0x80, 0x00 } },
    { "se",	N_("Northern Sami"),
	{ 0x44, 0x61, 0x76, 0x76, 0x69, 0x73, 0xC3, 0xA1, 0x6D, 0x65, 0x67, 0x69,
	  0x65, 0x6C, 0x6C, 0x61, 0x00 } },
    { "sg",	N_("Sango"),
	{ 0x79, 0xC3, 0xA2, 0x6E, 0x67, 0xC3, 0xA2, 0x20, 0x74, 0xC3, 0xAE, 0x20,
	  0x73, 0xC3, 0xA4, 0x6E, 0x67, 0xC3, 0xB6, 0x00 } },
    { "sh",	N_("Serbo-Croatian"),
	{ 0xD0, 0xA1, 0xD1, 0x80, 0xD0, 0xBF, 0xD1, 0x81, 0xD0, 0xBA, 0xD0, 0xBE,
	  0xD1, 0x85, 0xD1, 0x80, 0xD0, 0xB2, 0xD0, 0xB0, 0xD1, 0x82, 0xD1, 0x81,
	  0xD0, 0xBA, 0xD0, 0xB8, 0x00 } },
    { "si",	N_("Sinhalese"),
	{ 0xE0, 0xB7, 0x83, 0xE0, 0xB7, 0x92, 0xE0, 0xB6, 0x82, 0xE0, 0xB7, 0x84,
	  0xE0, 0xB6, 0xBD, 0x00 } },
    { "sk",	N_("Slovak"),
	{ 0x73, 0x6C, 0x6F, 0x76, 0x65, 0x6E, 0xC4, 0x8D, 0x69, 0x6E, 0x61, 0x00 } },
    { "sl",	N_("Slovenian"),
	{ 0x73, 0x6C, 0x6F, 0x76, 0x65, 0x6E, 0xC5, 0xA1, 0xC4, 0x8D, 0x69, 0x6E,
	  0x61, 0x00 } },
    { "sm",	N_("Samoan"), "gagana fa'a Samoa" },
    { "sn",	N_("Shona"), "chiShona" },
    { "so",	N_("Somali"), "Soomaaliga" },
    { "sq",	N_("Albanian"), "Shqip" },
    { "sr",	N_("Serbian"),
	{ 0xD1, 0x81, 0xD1, 0x80, 0xD0, 0xBF, 0xD1, 0x81, 0xD0, 0xBA, 0xD0, 0xB8,
	  0x20, 0xD1, 0x98, 0xD0, 0xB5, 0xD0, 0xB7, 0xD0, 0xB8, 0xD0, 0xBA, 0x00 } },
    { "ss",	N_("Swati"), "SiSwati" },
    { "st",	N_("Southern Sotho"), "seSotho" },
    { "su",	N_("Sundanese"), "Basa Sunda" },
    { "sv",	N_("Swedish"), "Svenska" },
    { "sw",	N_("Swahili"), "Kiswahili" },
    { "ta",	N_("Tamil"), 
	{ 0xE0, 0xAE, 0xA4, 0xE0, 0xAE, 0xAE, 0xE0, 0xAE, 0xBF, 0xE0, 0xAE, 0xB4,
	  0xE0, 0xAF, 0x8D, 0x00 } },
    { "te",	N_("Telugu"),
	{ 0xE0, 0xB0, 0xA4, 0xE0, 0xB1, 0x86, 0xE0, 0xB0, 0xB2, 0xE0, 0xB1, 0x81,
	  0xE0, 0xB0, 0x97, 0xE0, 0xB1, 0x81, 0x00 } },
    { "tg",	N_("Tajik"),
	{ 0xD1, 0x82, 0xD0, 0xBE, 0xD2, 0xB7, 0xD0, 0xB8, 0xD0, 0xBA, 0xD3, 0xA3,
	  0x00 } },
    { "th",	N_("Thai"),
	{ 0xE0, 0xB9, 0x84, 0xE0, 0xB8, 0x97, 0xE0, 0xB8, 0xA2, 0x00 } },
    { "ti",	N_("Tigrinya"),
	{ 0xE1, 0x89, 0xB5, 0xE1, 0x8C, 0x8D, 0xE1, 0x88, 0xAD, 0xE1, 0x8A, 0x9B,
	  0x00 } },
    { "tk",	N_("Turkmen"),
	{ 0x54, 0xC3, 0xBC, 0x72, 0x6B, 0x6D, 0x65, 0x6E, 0x00 } },
    { "tl",	N_("Tagalog"), "Tagalog" },
    { "tn",	N_("Tswana"), "seTswana" },
    { "to",	N_("Tonga"), "faka Tonga" },
    { "tr",	N_("Turkish"),
	{ 0x54, 0xC3, 0xBC, 0x72, 0x6B, 0xC3, 0xA7, 0x65, 0x00 } },
    { "ts",	N_("Tsonga"), "xiTsonga" },
    { "tt",	N_("Tatar"),
	{ 0xD1, 0x82, 0xD0, 0xB0, 0xD1, 0x82, 0xD0, 0xB0, 0xD1, 0x80, 0xD1, 0x87,
	  0xD0, 0xB0, 0x00 } },
    { "tw",	N_("Twi"), "Twi" },
    { "ty",	N_("Tahitian"),
	{ 0x52, 0x65, 0x6F, 0x20, 0x4D, 0xC4, 0x81, 0x60, 0x6F, 0x68, 0x69, 0x00 } },
    { "ug",	N_("Uighur"),
	{ 0x55, 0x79, 0xC6, 0xA3, 0x75, 0x72, 0x71, 0xC9, 0x99, 0x00 } },
    { "uk",	N_("Ukrainian"),
	{ 0xD1, 0x83, 0xD0, 0xBA, 0xD1, 0x80, 0xD0, 0xB0, 0xD1, 0x97, 0xD0, 0xBD,
	  0xD1, 0x81, 0xD1, 0x8C, 0xD0, 0xBA, 0xD0, 0xB0, 0x20, 0xD0, 0xBC, 0xD0,
	  0xBE, 0xD0, 0xB2, 0xD0, 0xB0, 0x00 } },
    { "ur",	N_("Urdu"),
	{ 0xE2, 0x80, 0xAB, 0xD8, 0xA7, 0xD8, 0xB1, 0xD8, 0xAF, 0xD9, 0x88, 0x00 } },
    { "uz",	N_("Uzbek"), "O'zbek" },
    { "ve",	N_("Venda"),
	{ 0x74, 0x73, 0x68, 0x69, 0x56, 0x65, 0x6E, 0xE1, 0xB8, 0x93, 0x61, 0x00 } },
    { "vi",	N_("Vietnamese"),
	{ 0x54, 0x69, 0xE1, 0xBA, 0xBF, 0x6E, 0x67, 0x20, 0x56, 0x69, 0xE1, 0xBB,
	  0x87, 0x74, 0x00 } },
    { "vo",	N_("Volapuek"),
	{ 0x56, 0x6F, 0x6C, 0x61, 0x70, 0xC3, 0xBC, 0x6B, 0x00 } },
    { "wa",	N_("Walloon"), "Walon" },
    { "wo",	N_("Wolof"), "Wollof" },
    { "xh",	N_("Xhosa"), "isiXhosa" },
    { "yi",	N_("Yiddish"),
	{ 0xE2, 0x80, 0xAB, 0xD7, 0x99, 0xD7, 0x99, 0xD6, 0xB4, 0xD7, 0x93, 0xD7,
	  0x99, 0xD7, 0xA9, 0x00 } },
    { "yo",	N_("Yoruba"),
	{ 0x59, 0x6F, 0x72, 0xC3, 0xB9, 0x62, 0xC3, 0xA1, 0x00 } },
    { "za",	N_("Zhuang"),
	{ 0x53, 0x61, 0xC9, 0xAF, 0x20, 0x63, 0x75, 0x65, 0xC5, 0x8B, 0xC6, 0x85,
	  0x00 } },
    { "zh",	N_("Chinese"),
	{ 0xE4, 0xB8, 0xAD, 0xE6, 0x96, 0x87, 0x00 } },
    { "zhs",	N_("Simplified Chinese"),
	{ 0xE7, 0xAE, 0x80, 0xE4, 0xBD, 0x93, 0xE4, 0xB8, 0xAD, 0xE6, 0x96, 0x87,
	  0x00 } },
    { "zht",	N_("Traditional Chinese"),
	{ 0xE6, 0xAD, 0xA3, 0xE9, 0xAB, 0x94, 0xE4, 0xB8, 0xAD, 0xE6, 0x96, 0x87,
	  0x00 } },
    { "zu",	N_("Zulu"), "isiZulu" },
    /* end of list marker, do not remove! */
    { NULL,	NULL,	{ 0 } },
};
