#ifndef _PP_IPC_H
#define _PP_IPC_H

#include <pp/pp_ipc_socket.h>

#ifdef  __cplusplus
extern "C" {
#endif //__cplusplus

int pp_ipc_init(void);
void pp_ipc_cleanup(void);


typedef struct pp_ipc_req_ctx_s pp_ipc_req_ctx_t;

typedef void (*pp_ipc_req_handler_t)(pp_ipc_req_ctx_t *ctx,
	pp_ipc_req_type_t type, int length, unsigned char *data);


// Register handler for given message type
int pp_ipc_register_handler(pp_ipc_req_type_t reqtype,
	pp_ipc_req_handler_t handler);

// Unregister handler
void pp_ipc_unregister_handler(pp_ipc_req_type_t reqtype);

// Send a response to the originator of the request
int pp_ipc_send_response(pp_ipc_req_ctx_t *ctx,
	pp_ipc_rsp_status_t status, int length, unsigned char *data);

// Duplicate request context for later response; must be free'd by caller
pp_ipc_req_ctx_t *pp_ipc_ctx_dup(pp_ipc_req_ctx_t *ctx);

#ifdef  __cplusplus
}
#endif //__cplusplus

#endif /* _PP_IPC_H */
