#ifndef _PP_IPC_SOCKET_H
#define _PP_IPC_SOCKET_H

// eric control socket client API
//
// Note: This file might be included from within kernel modules. Don't
//       include anything else from here!

#ifdef  __cplusplus
extern "C" {
#endif //__cplusplus

#define PP_IPC_SOCKET_PATH "/tmp/eric_control.socket"
#define PP_IPC_SOCKET_MTU 2048

typedef enum {
    PP_IPC_REQ_SETUP_PROTO,
    PP_IPC_REQ_IPMI
} pp_ipc_req_type_t;

typedef enum {
    PP_IPC_RSP_SUCCESS = 0,
    PP_IPC_RSP_ERROR
} pp_ipc_rsp_status_t;

typedef struct {
    pp_ipc_req_type_t request_type;
    unsigned char data[0];
} pp_ipc_req_head_t;

typedef struct {
    pp_ipc_rsp_status_t status;
    unsigned char data[0];
} pp_ipc_rsp_head_t;

#ifdef  __cplusplus
}
#endif //__cplusplus

#endif /* _PP_IPC_SOCKET_H */
