#include <pp/base.h>
#include <pp/ipc.h>
#include "ipc_socket.h"

static int initialized = 0;

int pp_ipc_init(void)
{
    if (initialized) return PP_ERR;
    if (PP_FAILED( ipc_socket_init() )) return PP_ERR;
    initialized = 1;
    return PP_SUC;
}

void pp_ipc_cleanup(void)
{
    if (!initialized) return;
    ipc_socket_cleanup();
    initialized = 0;
    return;
}

