#ifndef __IPMI_ERROR_H
#define __IPMI_ERROR_H

/* we use the following error codes:
   0          - no (or unknown) orror
   1..255     - IPMI completion codes
   300..399   - RMCP+ error codes (error_code is RCMPerror + 300)
   400...     - common errors (see below)
*/

enum {
    IPMI_ERROR_UNKNOWN_ERROR		=   0,

    IPMI_ERROR_RMCP_PLUS_OFFSET		= 300,

    /* common errors */
    IPMI_ERROR_NO_RESPONSE		= 400,
    IPMI_ERROR_LOOKUP_FAILED,
    IPMI_ERROR_AUTH_FAILED,
    IPMI_ERROR_ESTABLISH_SESSION,
    IPMI_ERROR_INVALID_PARAMETER,
    IPMI_ERROR_NOT_ENOUGH_MEMORY,
    IPMI_ERROR_NETWORK,
    IPMI_ERROR_NO_CONNECTION,
    IPMI_ERROR_INTERNAL,
    IPMI_ERROR_NO_PRIVILEGE,
    IPMI_ERROR_CLOSE_SESSION,
    IPMI_ERROR_NO_HOSTNAME,
    IPMI_ERROR_ENCRYPTION,
    IPMI_ERROR_SEND_FAILED,
    IPMI_ERROR_USERNAME_TOO_LONG,
    IPMI_ERROR_NO_20_SUPPORT,
    IPMI_ERROR_INTF_NOT_SUPPORTED,
    IPMI_ERROR_NO_PARAMETER,
    IPMI_ERROR_INVALID_COMMAND,
    IPMI_ERROR_NOT_CONNECTED,
    IPMI_ERROR_INVALID_GUID_LENGTH,
    IPMI_ERROR_COULD_NOT_USE_OPENIPMI,
    IPMI_ERROR_OPENIPMI_ERROR,
    IPMI_ERROR_INCOMPLETE_UPLOAD,
    IPMI_ERROR_BAD_CRC,
    IPMI_ERROR_INVALID_FIRMWARE,
    IPMI_ERROR_UPGRADE_FAILED,
    IPMI_ERROR_NO_SERIAL_NUMBER_SET,
    IPMI_ERROR_SERIAL_ALREADY_SET,
    IPMI_ERROR_NO_EMPTY_DEVICE,
    IPMI_ERROR_INVALID_FILE_SIZE,
    IPMI_ERROR_SMB_MOUNT_IN_PROGRESS,
    IPMI_ERROR_IMAGE_ACCESS_FAILED,
    IPMI_ERROR_COULD_NOT_OPEN_FILE,
    IPMI_ERROR_FILE_ACCESS_ERROR,
    IPMI_ERROR_INVALID_CHANNEL,
    IPMI_ERROR_CHANNEL_NOT_LAN_CHANNEL,
    IPMI_ERROR_COULD_NOT_PARSE_IP_ADDR,
    IPMI_ERROR_COULD_NOT_PARSE_MAC_ADDR,
    IPMI_ERROR_IMB_NOT_AVAILABLE,
    IPMI_ERROR_IMB_ERROR,
    IPMI_ERROR_NO_SUCH_DEVICE,
    IPMI_ERROR_SELFTEST_NOT_SUPPORTED,
    IPMI_ERROR_SELFTEST_FAILED,
    IPMI_ERROR_SELFTEST_BUSY,
    IPMI_ERROR_SELFTEST_NO_RESULT,
    IPMI_ERROR_SELFTEST_NO_MATCH,
};

void ipmi_reset_error(int * error);
void ipmi_set_error(int * error, int error_code);

#endif /* __IPMI_ERROR_H */

