#ifndef __IPMI_PARAMS_H
#define __IPMI_PARAMS_H

#include <pp/ipmi.h>

#define MAX_NO_IPMI_ARGV	8

typedef struct s_ipmitool_commandline {
    int argc;
    char *argv[MAX_NO_IPMI_ARGV];
} t_ipmitool_commandline;

t_ipmitool_commandline* init_cmdline(void);
void cleanup_cmdline(t_ipmitool_commandline *cmdline);

void cmdline_add(t_ipmitool_commandline *cmdline, char *command);

int cmdline_add_command(t_ipmitool_commandline *cmdline, char *command_in);

t_ipmitool_commandline* get_cmdline(pp_ipmi_parameter_t *params);

#endif /* __IPMI_PARAMS_H */
