#ifndef __IPMITOOL_H
#define __IPMITOOL_H

#include <pp/ipmi.h>

/* The original ipmitool code uses getopt for its configuration.
   We can't use it here because this is not thread safe. But we
   don't really need it, we don't call ipmitool by commandline.
   So we use a config structure instead.
*/
typedef struct s_ipmitool_config {
    // static strings
    const char *intfname;
    char *privlvl;
    char *authtype;
    // flags
    int verbose;
    int port;
    int bmc_addr;
    int own_addr;
    // serial settings
    int serial_port;
    int baud_rate;
    char parity[2];
    int bits;
    int stop2;
    int hwf;
    int swf;
    // dynamically allocated strings
    char *hostname;
    char *device;
    char *password;
    char *username;
    char *oemtype;
    // loopi channel
    int loopi_chan;
} ipmitool_config_t;

extern int ipmitool_main(ipmitool_config_t *config,
			 pp_ipmi_command_t cmd,
			 int subcommand,
			 pp_ipmi_parameter_t *params,
			 pp_ipmi_return_t *ret, int * error);

#endif /* __IPMITOOL_H */

