/**
 * \file ipmi_kvm.c
 *
 * Description: KVM command extension
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#include <config.h>

#include <ipmitool/ipmi.h>
#include <ipmitool/ipmi_kvm.h>
#include <ipmitool/ipmi_intf.h>
#include <ipmitool/ipmi_print.h>
#include <ipmitool/ipmi_error.h>
#include <ipmitool/ipmi_strings.h>

static int ipmi_kvm_reset(struct ipmi_intf * intf, int * error)
{
    struct ipmi_rs * rsp;
    struct ipmi_rq req;
    //struct bitfield_data * bf;

    memset(&req, 0, sizeof(req));
    req.msg.netfn = IPMI_NETFN_KVM;
    req.msg.cmd = BMC_KVM_RESET;

    rsp = intf->sendrecv(intf, &req, error);
    if (!rsp) {
        ipmi_printf("Error in BMC KVM Reset command\n");
        return -1;
    }
    if (rsp->ccode) {
        ipmi_printf("BMC KVM Reset command failed: %s\n",
               val2str(rsp->ccode, completion_code_vals));
        return -1;
    }

    ipmi_printf("Success!\n");

    return 0;
}

int ipmi_kvm_main(struct ipmi_intf * intf, int subcmd, pp_ipmi_parameter_t *params UNUSED, pp_ipmi_return_t *ret UNUSED, int * error)
{
    switch ((pp_ipmi_kvm_subcommand_t) subcmd) {
    	case PP_IPMI_KVM_SUBCMD_RESET:
    	    return ipmi_kvm_reset(intf, error);
    	default:
    	    ipmi_printf("Invalid KVM command: %d\n", subcmd);
			ipmi_set_error(error, IPMI_ERROR_INVALID_COMMAND);
    	    return -1;
    }
}

