/**
 * \file ipmi_oem_pp.c
 *
 * Description: Peppercon IPMI OEM commands
 *
 * (c) 2005 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 *                        Ingo van Lil <inva@peppercon.de>
 */

#include <config.h>

#include <ipmitool/ipmi.h>
#include <ipmitool/ipmi_oem_pp.h>
#include <ipmitool/ipmi_intf.h>
#include <ipmitool/ipmi_print.h>
#include <ipmitool/ipmi_error.h>
#include <ipmitool/ipmi_strings.h>

static int ipmi_oem_pp_set_pwm(struct ipmi_intf * intf,
                        pp_ipmi_parameter_t *params,
                        pp_ipmi_return_t *ret UNUSED,
                        int * error)
{
    const char *cmd_name = "[OEM Peppercon] Set PWM Params";
    struct ipmi_rs *rsp;
    struct ipmi_rq req;

    unsigned char b[2];
    b[0] = (unsigned char)params->data.oem_pp_set_pwm.pwm_id;
    b[1] = (unsigned char)params->data.oem_pp_set_pwm.duty_cycle;

    memset(&req, 0, sizeof(req));
    req.msg.netfn = IPMI_NETFN_OEM_PP;
    req.msg.cmd = IPMI_SUBCMD_OEM_PP_SET_PWM;
    req.msg.data_len = 2;
    req.msg.data = b;

    rsp = intf->sendrecv(intf, &req, error);
    if (!rsp) {
        ipmi_printf("'%s' failed\n", cmd_name);
        return -1;
    }
    if (rsp->ccode) {
        ipmi_printf("'%s' failed: %s\n", cmd_name,
               val2str(rsp->ccode, completion_code_vals));
        return -1;
    }

    return 0;
}

int ipmi_oem_pp_main(struct ipmi_intf * intf,
                     int subcmd,
                     pp_ipmi_parameter_t *params,
                     pp_ipmi_return_t *ret,
                     int * error)
{
    switch ((pp_ipmi_kvm_subcommand_t) subcmd) {
/* TODO:
	case PP_IPMI_OEM_PP_GET_PWM:
	    return ipmi_oem_pp_get_pwm(intf, params, ret, error);
	    break;
*/
	case PP_IPMI_OEM_PP_SET_PWM:
	    return ipmi_oem_pp_set_pwm(intf, params, ret, error);
	    break;
	default:
	    ipmi_printf("Invalid OEM Peppercon command: %d\n", subcmd);
	    ipmi_set_error(error, IPMI_ERROR_INVALID_COMMAND);
	    return -1;
    }
}

