/**
 * ipmi_raw.c
 *
 * (c) 2006 Peppercon AG, Thomas Rendelmann <thomas.rendelmann@raritan.com>
 */

#include <config.h>

#include <pp/vector.h>

#include <ipmitool/ipmi.h>
#include <ipmitool/ipmi_kvm.h>
#include <ipmitool/ipmi_intf.h>
#include <ipmitool/ipmi_print.h>
#include <ipmitool/ipmi_error.h>
#include <ipmitool/ipmi_strings.h>

#include <ipmitool/ipmi_raw.h>

#include <ipmi_return.h>

static int ipmi_process_raw(struct ipmi_intf * intf, pp_ipmi_raw_param_t *params,
			    pp_ipmi_return_t *ipmi_ret, int *error) {
    unsigned char *data = NULL;
    int ret = -1;
    size_t size = 0;

    struct ipmi_rs * rsp;
    struct ipmi_rq req;

    if (ipmi_init_raw_data(ipmi_ret)) {
	ipmi_set_error(error, IPMI_ERROR_NOT_ENOUGH_MEMORY);
	goto bail;
    }

    if (params->data && (size = vector_size(params->data))) {
	unsigned int i;
	if (!(data = malloc(size))) {
	    ipmi_set_error(error, IPMI_ERROR_NOT_ENOUGH_MEMORY);
	    goto bail;
	}

	for (i = 0; i < size; i++) {
	    data[i] = vector_get_u_int(params->data, i);
	}
    }

    memset(&req, 0, sizeof(req));
    req.msg.netfn = params->net_fn;
    req.msg.cmd = params->cmd;
    req.msg.data = data;
    req.msg.data_len = size;

    rsp = intf->sendrecv(intf, &req, error);
    if (!rsp) {
        ipmi_printf("Error in RAW command\n");
        goto bail;
    }

    if (rsp->ccode) {
	ipmi_ret->data.raw_data.completion_code = rsp->ccode;
    } else {
	int i;
	ipmi_ret->data.raw_data.completion_code = 0;
	for (i = 0; i < rsp->data_len; i++) {
	    vector_add_u_int(ipmi_ret->data.raw_data.data, rsp->data[i]);
	}
    }

    ret = 0;

bail:
    free(data);
    return ret;
}

int ipmi_raw_main(struct ipmi_intf * intf, int subcmd, pp_ipmi_parameter_t *params,
		  pp_ipmi_return_t *ret, int * error)
{
    switch ((pp_ipmi_raw_subcommand_t) subcmd) {
    	case PP_IPMI_RAW_SUBCMD_RAW:
    	    return ipmi_process_raw(intf, &params->data.raw_data, ret, error);
    	default:
    	    ipmi_printf("Invalid RAW command: %d\n", subcmd);
			ipmi_set_error(error, IPMI_ERROR_INVALID_COMMAND);
    	    return -1;
    }
}

