/*
 * Copyright (c) 2003 Sun Microsystems, Inc.  All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * Redistribution of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * Redistribution in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind.
 * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES,
 * INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.
 * SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.  IN NO EVENT WILL
 * SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA,
 * OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
 * PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
 * LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE,
 * EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed or intended for use
 * in the design, construction, operation or maintenance of any nuclear
 * facility.
 */

#include <stdlib.h>
#include <stdio.h>

#ifndef _WIN32
#include <inttypes.h>
#endif

#include <string.h>
#include <sys/types.h>

#ifndef WIN32
#include <unistd.h>
#endif

#ifdef WIN32
#include <pp/win32.h>
#undef D
#include <winsock2.h>
#include <windows.h>
#endif // WIN32

#include <openssl/md2.h>
#include <openssl/md5.h>

#include <ipmitool/helper.h>
#include <ipmitool/bswap.h>
#include <ipmitool/ipmi.h>
#include <ipmitool/ipmi_intf.h>
#include <ipmitool/ipmi_print.h>

#include <config.h>
#include "auth.h"

/*
 * multi-session authcode generation for MD5
 * H(password + session_id + msg + session_seq + password)
 *
 * Use OpenSSL implementation of MD5 algorithm if found
 */
uint8_t * ipmi_auth_md5(struct ipmi_session * s, uint8_t * data, int data_len)
{
	MD5_CTX ctx;
	static uint8_t md[16];
	uint32_t temp;

#ifdef WORDS_BIGENDIAN
	temp = BSWAP_32(s->in_seq);
#else
	temp = s->in_seq;
#endif
	memset(md, 0, 16);
	memset(&ctx, 0, sizeof(MD5_CTX));

	MD5_Init(&ctx);
	MD5_Update(&ctx, (const uint8_t *)s->authcode, 16);
	MD5_Update(&ctx, (const uint8_t *)&s->session_id, 4);
	MD5_Update(&ctx, (const uint8_t *)data, data_len);
	MD5_Update(&ctx, (const uint8_t *)&temp, sizeof(uint32_t));
	MD5_Update(&ctx, (const uint8_t *)s->authcode, 16);
	MD5_Final(md, &ctx);

	return md;
}

/* 
 * multi-session authcode generation for MD2
 * H(password + session_id + msg + session_seq + password)
 *
 * Use OpenSSL implementation of MD2 algorithm if found.
 * This function is analogous to ipmi_auth_md5
 */
uint8_t * ipmi_auth_md2(struct ipmi_session * s, uint8_t * data, int data_len)
{
	MD2_CTX ctx;
	static uint8_t md[16];
	uint32_t temp;

#ifdef WORDS_BIGENDIAN
	temp = BSWAP_32(s->in_seq);
#else
	temp = s->in_seq;
#endif
	memset(md, 0, 16);
	memset(&ctx, 0, sizeof(MD2_CTX));

	MD2_Init(&ctx);
	MD2_Update(&ctx, (const uint8_t *)s->authcode, 16);
	MD2_Update(&ctx, (const uint8_t *)&s->session_id, 4);
	MD2_Update(&ctx, (const uint8_t *)data, data_len);
	MD2_Update(&ctx, (const uint8_t *)&temp, sizeof(uint32_t));
	MD2_Update(&ctx, (const uint8_t *)s->authcode, 16);
	MD2_Final(md, &ctx);

	return md;
}


/* special authentication method */
uint8_t * ipmi_auth_special(struct ipmi_session * s)
{
	MD5_CTX ctx;
	static uint8_t md[16];
	uint8_t challenge[16];
	int i;

	memset(challenge, 0, 16);
	memset(md, 0, 16);
	memset(&ctx, 0, sizeof(MD5_CTX));

	MD5_Init(&ctx);
	MD5_Update(&ctx, (const uint8_t *)s->authcode, strlen((char *)s->authcode));
	MD5_Final(md, &ctx);

	for (i=0; i<16; i++)
		challenge[i] = s->challenge[i] ^ md[i];

	memset(md, 0, 16);
	memset(&ctx, 0, sizeof(MD5_CTX));

	MD5_Init(&ctx);
	MD5_Update(&ctx, (const uint8_t *)challenge, 16);
	MD5_Final(md, &ctx);

	return md;
}

