#include "lanplus.h"
#include "ipmitool/ipmi_constants.h"

const struct valstr ipmi_rakp_return_codes[] = {

	{ IPMI_RAKP_STATUS_NO_ERRORS,                          "no errors"                            },
	{ IPMI_RAKP_STATUS_INSUFFICIENT_RESOURCES_FOR_SESSION, "Insufficient resources for session"   },
	{ IPMI_RAKP_STATUS_INVALID_SESSION_ID,                 "Invalid session ID"                   },
	{ IPMI_RAKP_STATUS_INVALID_PAYLOAD_TYPE,               "Invalid payload type"                 },
	{ IPMI_RAKP_STATUS_INVALID_AUTHENTICATION_ALGORITHM,   "Invalid authentication algorithm"     },
	{ IPMI_RAKP_STATUS_INVALID_INTEGRITTY_ALGORITHM,       "Invalid integrity algorithm"          },
	{ IPMI_RAKP_STATUS_NO_MATCHING_AUTHENTICATION_PAYLOAD, "No matching authentication algorithm" },
	{ IPMI_RAKP_STATUS_NO_MATCHING_INTEGRITY_PAYLOAD,      "No matching integrity payload"        },
	{ IPMI_RAKP_STATUS_INACTIVE_SESSION_ID,                "Inactive session ID"                  },
	{ IPMI_RAKP_STATUS_INVALID_ROLE,                       "Invalid role"                         },
	{ IPMI_RAKP_STATUS_UNAUTHORIZED_ROLE_REQUESTED,        "Unauthorized role requested"          },
	{ IPMI_RAKP_STATUS_INSUFFICIENT_RESOURCES_FOR_ROLE,    "Insufficient resources for role"      },
	{ IPMI_RAKP_STATUS_INVALID_NAME_LENGTH,                "Invalid name length"                  },
	{ IPMI_RAKP_STATUS_UNAUTHORIZED_NAME,                  "Unauthorized name (Invalid username)" },
	{ IPMI_RAKP_STATUS_UNAUTHORIZED_GUID,                  "Unauthorized GUID"                    },
	{ IPMI_RAKP_STATUS_INVALID_INTEGRITY_CHECK_VALUE,      "invalid integrity check value"        },
	{ IPMI_RAKP_STATUS_INVALID_INTEGRITY_CHECK_VALUE,      "Invalid integrity check value"        },
	{ IPMI_RAKP_STATUS_INVALID_CONFIDENTIALITY_ALGORITHM,  "Invalid confidentiality algorithm"    },
	{ IPMI_RAKP_STATUS_NO_CIPHER_SUITE_MATCH,              "No matching cipher suite"             },
	{ IPMI_RAKP_STATUS_ILLEGAL_PARAMTER,                   "Illegal parameter"                    },
	{ 0,                                                   0                                      },
};


const struct valstr ipmi_priv_levels[] = {
	{ IPMI_PRIV_CALLBACK, "callback" },
	{ IPMI_PRIV_USER,     "user"     },
	{ IPMI_PRIV_OPERATOR, "operator" },
	{ IPMI_PRIV_ADMIN,    "admin"    },
	{ IPMI_PRIV_OEM,      "oem"      },
	{ 0,                  0          },
};




