/******************************************************************************\
* cat_debug.h                                                                  *
*                                                                              *
* CURSOR ACTIVITY TRACKING                                                     *
*                                                                              *
* ... sometimes even rock-solid code needs debugging ;-)                       *
*                                                                              *
* Copyright 2005 Peppercon AG                                                  *
* Thomas Weber tweb@peppercon.de                                               *
\******************************************************************************/

#ifndef __CAT_DEBUG_H__
#define __CAT_DEBUG_H__

#include "cat_internal.h"

#if defined(CAT_DEBUG)

/********************************** DEFINES ***********************************/

/* CDMSG FLAGS */
#define CAT_CDMSG_TRUE 1
#define CAT_CDMSG_FALSE 0

#define CAT_CDMSG_ERROR 1
#define CAT_CDMSG_WARNING 1
#define CAT_CDMSG_INFO 1
#define CAT_CDMSG_MTX 0
#define CAT_CDMSG_BLABLA 0

#define CAT_CDMSG_BLOCK_MATCHING_INFO 0

#define CAT_CDMSG_CAT_QUEUE_INFO 0

#define CAT_CDMSG_CONDENSATION_INFO 1
#define CAT_CDMSG_CONDENSATION_INTELLI_INFO 0

#define CAT_CDMSG_DIFFMAP_INFO 0

#define CAT_CDMSG_GLOBAL_LOCALIZATION_INFO 1

#define CAT_CDMSG_LOOKUP_TABLE_INFO 0

#define CAT_CDMSG_SYNC_INFO 0
#define CAT_CDMSG_INTELLI_MOVE_INFO 0

/* other "features" */

#define noCAT_DUMP_BMPS

#define CAT_PROFILE_APPROACHING

#define CAT_COND_PROFILE_CONDENSATION 0

#define noCAT_LOOKUP_TABLE_DEBUG

#define CAT_SHAKE 0

#define noCAT_DISABLE_TRACKING

/********************************** GENERIC ***********************************/

#define CDMSG(cond, fmt, args...) { \
    if((cond)) { \
        printf("%s:%d: %s(): ", __FILE__, __LINE__, ___F); \
        printf(fmt, ##args); \
        usleep(1000); \
    } \
}

#if defined(CAT_DUMP_BMPS)
# define DBG_WRITE_BITMAP(img, name) write_bitmap(img, name)
#else /* CAT_DUMP_BMPS */
# define DBG_WRITE_BITMAP(args...)
#endif /* CAT_DUMP_BMPS */

//#if defined(CAT_DISABLE_TRACKING) && !defined(CAT_LOOKUP_TABLE_DEBUG)
//# define CAT_LOOKUP_TABLE_DEBUG
//#endif /* CAT_DISABLE_TRACKING && !CAT_LOOKUP_TABLE_DEBUG */

/********************************* CAT QUEUE **********************************/

void cat_debug_print_diffmap(u_int32_t *diffmap, size_t size, 
                             u_int line_len, u_int width, u_int height);

#define DEBUG_CQDE(__cqde__) \
    cat_debug_print_diffmap((__cqde__).data, (__cqde__).size, \
                            (__cqde__).line_len, (__cqde__).width, \
                            (__cqde__).height);

void cat_debug_draw_diffmap(u_int32_t *diffmap, size_t size, 
                            u_int line_len, u_int width, u_int height,
                            t_bitmap *img, t_rgb color);

#define DEBUG_DRAW_CQDE(__cqde__, __img__, __color__) \
    cat_debug_draw_diffmap((__cqde__).data, (__cqde__).size, \
                           (__cqde__).line_len, (__cqde__).width, \
                           (__cqde__).height, __img__, __color__);

/******************************** CLUSTERING **********************************/

int cat_debug_clustering_draw_clusters(u_int clusters, int *cluster_ids,
                                       cat_sample32_t *samples,
                                       t_bitmap *img, t_rgb color);


/********************************** DRAWING ***********************************/

int cat_debug_draw_samples(cat_sample32_t *samples, t_bitmap *img, t_rgb color);

int cat_debug_draw_rect(u_int x1, u_int y1, u_int x2, u_int y2,
                        t_bitmap *img, t_rgb color);

#else /* CAT_DEBUG *********** dummy section ;-) ******************************/

#define CDMSG(cond, fmt, args...)
#define DEBUG_CQDE(__cqde__)
#define DBG_WRITE_BITMAP(args...)

#endif /* CAT_DEBUG */

#endif /* __CAT_DEBUG_H__ */
