/* 
  for libpp_cim_proto / kx2.
*/

/* system includes */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <malloc.h>
#include <sched.h>

/* firmware includes */
#include <pp/base.h>
#include <pp/cim_proto_lib.h>

/* local includes */
#include "driver.h"

/* object functions */
static int cleanup(driver_t* obj);
static int reconfigure(driver_t* obj);
static int send_pdu(driver_t*, const void* pdu, const int length, const input_t input);
static int suspend(driver_t*);
static int resume(driver_t*);
static int ping(driver_t*, char** info);
static int is_equal(driver_t* obj, driver_t* d);
static int reset_driver(driver_t* obj);

extern DATALINK_OBJECTS* datalink;

static int data_link_number_g = 0;

int init_comm_proto_cim(driver_t* obj, int data_link_number, int /* my_cim_type */, int /* target_port_number */) {
    /* create the driver */
    assert(obj);
    
    obj->comm_proto.id = __FUNCTION__;
    obj->comm_proto.is_equal = is_equal;
    obj->comm_proto.cleanup = cleanup;
    obj->comm_proto.reconfigure = reconfigure;
    obj->comm_proto.send_pdu = send_pdu;
    obj->comm_proto.suspend = suspend;
    obj->comm_proto.resume = resume;
    obj->comm_proto.ping = ping;
    obj->comm_proto.reset_driver = reset_driver;

    data_link_number_g = data_link_number;
 
    return 0;
}

static int is_equal(driver_t * /* obj */, driver_t * /* d */) {

    //printf("inside %s\n", __PRETTY_FUNCTION__);
    // FIXME: implement this function
    return 0;
}

static int reset_driver(driver_t * /* obj */ ) {

    // printf("inside %s\n", __PRETTY_FUNCTION__);
    // FIXME: implement this function

    return 0;
}

static int cleanup(driver_t * /* obj */ ) {

    // printf("inside %s\n", __PRETTY_FUNCTION__);
    // FIXME: implement this function

    return 0;
}

static int ping(driver_t * /* obj */, char** info) {
    if (info) {
	*info = strdup("pong");
    }

    // printf("inside %s\n", __PRETTY_FUNCTION__);
    // FIXME: implement this function
    
    return 1;
}

static int suspend (driver_t * /* obj */ ) {
    // printf("inside %s\n", __PRETTY_FUNCTION__);
    // FIXME: implement this function


    return 0;
}

static int resume (driver_t * /* obj */) {
    // printf("inside %s\n", __PRETTY_FUNCTION__);
    // FIXME: implement this function
    return 0;
}

static int reconfigure(driver_t * /* obj */ ) {
    // printf("inside %s\n", __PRETTY_FUNCTION__);
    // FIXME: implement this function
    return 0;
}
    
static int send_pdu(driver_t * obj, const void* pdu, const int length, const input_t input ) {
    assert(obj);
    assert(datalink[obj->data_link].object);
    int input_type = INPUT_TYPE_KB; // by default;

    if ( PP_KM_INPUT_MOUSE == input )
    {
        input_type = INPUT_TYPE_MOUSE;
    }
    assert( datalink != NULL );
    int result =  ((datalink[obj->data_link].object->CIM_SendKBMouseData((const BYTE *)pdu, length, input_type) >= 0) ? 0 : -1);
    
    return result;
}
