/* layer: comm_proto_pppp
   data path: send_pdu() -> FD
*/

/* system includes */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <malloc.h>
#include <sched.h>

/* firmware includes */
#include <pp/base.h>
#include <liberic_misc.h>
#include <liberic_pthread.h>
#include <pp/minicom.h>

/* local includes */
#include "driver.h"
#include "kmebase_int.h"
#include "comm_proto_pppp.h"

/* object functions */
static int cleanup(driver_t* obj);
static int reconfigure(driver_t* obj);
static int send_pdu(driver_t*, const char* pdu, const int length, const input_t input);
static int suspend(driver_t*);
static int resume(driver_t*);
static int ping(driver_t*, char** info);
static int is_equal(driver_t* obj, driver_t* d);

int init_comm_proto_minicom(driver_t* obj) {
    /* create the driver */
    comm_proto_data_t* context;

    assert(obj);
    
    obj->comm_proto.id = __FUNCTION__;
    obj->comm_proto.is_equal = is_equal;
    obj->comm_proto.data = NULL;
    obj->comm_proto.cleanup = cleanup;
    obj->comm_proto.reconfigure = reconfigure;
    obj->comm_proto.send_pdu = send_pdu;
    obj->comm_proto.suspend = suspend;
    obj->comm_proto.resume = resume;
    obj->comm_proto.ping = ping;

    /* initializes our private data */
    obj->comm_proto.data = malloc(sizeof(comm_proto_data_t));
    if (obj->comm_proto.data == NULL) {
	exit(1);
    }
    context = (comm_proto_data_t*)obj->comm_proto.data;
    /* TODO TIMEOUT */
    
    return 0;
}

static int cleanup(driver_t* obj ) {
    return 0;
}


static int is_equal(driver_t* obj, driver_t* d) {
    assert(obj);
    assert(d);
    
    if (!strcmp(obj->comm_proto.id, d->comm_proto.id)) {
	return 1;
    } else {
	return 0;
    }
}



static int reconfigure(driver_t* obj ) {
    return 0;
}
    
static int ping(driver_t* obj , char** info) {
    if (info) {
	*info = strdup("pong");
    }
    return 0;
}


static int send_pdu(driver_t* obj , const char* pdu, const int length, const input_t input) {
    pp_log("send_pdu: %d\n", length);
    pp_minicom_send_data(input, pdu, length);

    return 0;
}

static int suspend (driver_t* obj ) {
    return 0;
}

static int resume (driver_t* obj ) {
    return 0;
}
    
