#ifndef _COMM_PROTO_PPPP_
#define _COMM_PROTO_PPPP_

#include "kmebase_int.h"

#define KME_SEND_STR                      -1

#define KME_RESUME      0
#define KME_SUSPENDED   1
#define KME_SUSPEND_REQ 2
#define KME_EXIT        3
#define KME_STOPPED     4
#define KME_RUNNING     5

#define KME_RECV_THREAD_TIMEOUT 1
#define MAX_BUF_LEN 50    

typedef struct _comm_proto_data_t {
    pthread_t kme_thread;
    unsigned char kme_thread_run;
    int kme_prompt_wait;
    unsigned int kme_prompt_error;
    pthread_cond_t kme_wait_cond;
    pthread_cond_t kme_prompt_cond;
    pthread_cond_t response_buffer_cond;
    pthread_mutex_t send_data_mtx;
    pthread_mutex_t kme_prompt_cond_mtx;
    pthread_mutex_t response_buffer_list_mtx;
    pthread_mutex_t response_buffer_cond_mtx;
    buffer_list_entry_t buffer_list[KME_RESPONSE_MAX];
    unsigned long timeout;
    int kme_suspend_flag;
    pthread_mutex_t kme_suspend_cond_mtx;
    pthread_mutex_t kme_resume_cond_mtx;
    pthread_cond_t  kme_suspend_cond;
    pthread_cond_t  kme_resume_cond;
    int kmefd;
    int kme_is_dead;
    int (*send_data) (struct _comm_proto_data_t* context, int slen, const char* s);
    int (*read_data) (struct _comm_proto_data_t* context, int* nn, char* buf);    
    unsigned char i2c_addr; /* only used when protocol is pppp_i2c */
    int reset_pin;
} comm_proto_data_t;
int init_comm_proto_pppp(driver_t* obj, int reset_pin);

#endif /* !_COMM_PROTO_PPPP_ */
