#ifndef _IIP_DATA_H_
#define _IIP_DATA_H_

#include <pthread.h>

#define MAX_ACCEL_STEPS		10	/* maximum acceleration changes */

/* a 2D point */
typedef struct s_point {
	int pos_x;
	int pos_y;
} t_point;

/* RGB color value */
typedef struct s_rgb {
	unsigned short b;	/* blue */
	unsigned short g;	/* green */
	unsigned short r;	/* red */
} t_rgb;

/* HSV color value */
typedef struct s_hsv {
	unsigned short v;	/* value (intensity) */
	unsigned short s;	/* saturation */
	unsigned short h;	/* hue */
} t_hsv;

/* a bitmap */
typedef struct s_bitmap {
	unsigned int width;
	unsigned int height;
	t_rgb *rgb;		/* the color data */
} t_bitmap;

/* obj structure is a collection of 
 * a mouse function and its reverse mouse funktion */
typedef struct s_mouse_func {
    int id;
    long (*fm_in2out)(long);
    long (*fm_out2in)(long);
} t_mouse_func;
    
/* the mouse universe structure, tracks current positions
   and state of mouse movements */
typedef struct {
    int state;			/* current table state */
    int mode;			/* acc table on/off (direct mode) */
    float scaling;		/* scaling amount for direct mode */
    float m[MAX_ACCEL_STEPS];	/* rise for each accel-step */
    int x0[MAX_ACCEL_STEPS];	/* offset for each accel-step */
    int xmax[MAX_ACCEL_STEPS];	/* range of an accel step */
    int ymax[MAX_ACCEL_STEPS];
    int accel_steps;
    t_mouse_func fm_corr;       /* correction function, used to
				   correct the mouse distortion possibly
				   introduced by other translation devices
				   like G&D switches or such things */
    long cur_x;			/* current virtual mouse positions */
    long cur_y;
    int cursor_state;
} t_mouse_data;

/* structure to hold specific data for each kvm port */
typedef struct {
    int u_index;              /* index of kvm unit obj port is part of */
    int index;                /* index of port in its kvm unit */
    pthread_mutex_t mtx;
    t_mouse_data mouse_data;
} km_kvm_entry_t;

#endif
