/*****************************************************************************
* iipptr_help.h                                                              *
*                                                                            *
* Copyright 2002 Peppercon AG                                                *
* Author: Thomas Rendelmann                                                  *
*                                                                            *
* Part of liberic_km                                                         *
* mouse driver iipps2 for Intelligent Mouse cursor Tracking                  *
*                                                                            *
* Contains three functions needed in the other modules                       *
* one finds a bitmap (usually the mouse cursor) in the current framebuffer,  *
* another one converts pixels to rgb and a third one takes a screenshot      *
* of a certain region inbetween the framebuffer                              *
*****************************************************************************/

#ifndef __IIPPTR_HELP_H
#define __IIPPTR_HELP_H

#include <pp/grab.h>
#include "iipptr_data.h"

/* MSE algorithm */
int mse_compare(t_bitmap *screen, t_bitmap *fit, int fit_x, int fit_y, 
                t_bitmap *mask, int search_left, int search_top,
                int search_width, int search_height, t_point *found);

/* obj function tries to find one bitmap in the current framebuffer
   using difference formation */
int difference(pp_grab_client_t *grab_client, t_bitmap *fit, t_bitmap *mask, t_point *center,
	       int search_diff_x, int search_diff_y, t_point *found);

/* obj function takes a screenshot and returns it as a bitmap */
int screenshot(pp_grab_client_t *grab_client, t_bitmap *screen,
	       u_short left, u_short top, u_short right, u_short bottom);

/* obj function convertes a whole area in the current framebuffer into
   a t_bitmap */
int fb_to_rgb_area(pp_grab_client_t *grab_client, t_bitmap *bitmap,
		   u_short left, u_short top, u_short width, u_short height);

#if 0
/* convert a RGB value to HSV model (hue, saturation, value) */
int rgb_to_hsv(t_rgb *rgb, t_hsv *hsv);
#endif

#endif /* __IIPPTR_HELP_H */
