#include <stdlib.h>
#include <stdio.h>

#include "kbd.h"
#include "kbd_intern.h"
#include "pp/base.h"

#define KEYDEF_NR_DEFAULTS 103	/* 102 keys + one virtual for Break (Ctrl+Pause) */

static keyspecial_t ks_nav[MAX_KEYSPECIALS] = {
    {{ 85,  41,  53}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{ 85,  41, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{ 85,  53, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{ 41,  53, 255}, {0xE0, 0xAA, 0xE0, 0xB6, 0x00, 0x00}, {0xE0, 0x36, 0xE0, 0x2A, 0x00, 0x00}},
    {{ 41, 255, 255}, {0xE0, 0xAA, 0x00, 0x00, 0x00, 0x00}, {0xE0, 0x2A, 0x00, 0x00, 0x00, 0x00}},
    {{ 53, 255, 255}, {0xE0, 0xB6, 0x00, 0x00, 0x00, 0x00}, {0xE0, 0x36, 0x00, 0x00, 0x00, 0x00}},
    {{ 85, 255, 255}, {0xE0, 0x2A, 0x00, 0x00, 0x00, 0x00}, {0xE0, 0xAA, 0x00, 0x00, 0x00, 0x00}}
};

static keyspecial_t ks_numdiv[MAX_KEYSPECIALS] = {
    {{ 41,  53, 255}, {0xE0, 0xAA, 0xE0, 0xB6, 0x00, 0x00}, {0xE0, 0x36, 0xE0, 0x2A, 0x00, 0x00}},
    {{ 41, 255, 255}, {0xE0, 0xAA, 0x00, 0x00, 0x00, 0x00}, {0xE0, 0x2A, 0x00, 0x00, 0x00, 0x00}},
    {{ 53, 255, 255}, {0xE0, 0xB6, 0x00, 0x00, 0x00, 0x00}, {0xE0, 0x36, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
};

static keyspecial_t ks_print[MAX_KEYSPECIALS] = {
    {{ 41,  54, 255}, {0xE0, 0x37, 0x00, 0x00, 0x00, 0x00}, {0xE0, 0xB7, 0x00, 0x00, 0x00, 0x00}},
    {{ 41,  58, 255}, {0xE0, 0x37, 0x00, 0x00, 0x00, 0x00}, {0xE0, 0xB7, 0x00, 0x00, 0x00, 0x00}},
    {{ 53,  54, 255}, {0xE0, 0x37, 0x00, 0x00, 0x00, 0x00}, {0xE0, 0xB7, 0x00, 0x00, 0x00, 0x00}},
    {{ 53,  58, 255}, {0xE0, 0x37, 0x00, 0x00, 0x00, 0x00}, {0xE0, 0xB7, 0x00, 0x00, 0x00, 0x00}},
    {{ 55, 255, 255}, {0x54, 0x00, 0x00, 0x00, 0x00, 0x00}, {0xD4, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{ 57, 255, 255}, {0x84, 0x37, 0x00, 0x00, 0x00, 0x00}, {0xF0, 0x84, 0x00, 0x00, 0x00, 0x00}},  
    {{ 72, 255, 255}, {0xE0, 0x2A, 0xE0, 0x37, 0x00, 0x00}, {0xE0, 0xB7, 0xE0, 0xAA, 0x00, 0x00}}
};

static keyspecial_t ks_pause[MAX_KEYSPECIALS] = {
    {{ 54, 255, 255}, {0xE0, 0x46, 0xE0, 0xC6, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{ 58, 255, 255}, {0xE0, 0x46, 0xE0, 0xC6, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{ 74, 255, 255}, {0xE1, 0x1D, 0x45, 0xE1, 0x9D, 0xC5}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
};

static keydef_t keydef_defaults[KEYDEF_NR_DEFAULTS] = {
    {   0,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x29, 0x00 }, 0x0E, NULL },	/* ~		*/
    {   1,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x02, 0x00 }, 0x16, NULL },	/* 1		*/
    {   2,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x03, 0x00 }, 0x1E, NULL },	/* 2		*/
    {   3,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x04, 0x00 }, 0x26, NULL },	/* 3		*/
    {   4,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x05, 0x00 }, 0x25, NULL },	/* 4		*/
    {   5,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x06, 0x00 }, 0x2E, NULL },	/* 5		*/
    {   6,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x07, 0x00 }, 0x36, NULL },	/* 6		*/
    {   7,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x08, 0x00 }, 0x3D, NULL },	/* 7		*/
    {   8,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x09, 0x00 }, 0x3E, NULL },	/* 8		*/
    {   9,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x0A, 0x00 }, 0x46, NULL },	/* 9		*/
    {  10,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x0B, 0x00 }, 0x45, NULL },	/* 0		*/
    {  11,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x0C, 0x00 }, 0x4E, NULL },	/* -		*/
    {  12,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x0D, 0x00 }, 0x55, NULL },	/* =		*/
    {  13,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x0E, 0x00 }, 0x66, NULL },	/* <-		*/
    {  14,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x0F, 0x00 }, 0x0D, NULL },	/* TAB		*/
    {  15,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x10, 0x00 }, 0x15, NULL },	/* Q		*/
    {  16,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x11, 0x00 }, 0x1D, NULL },	/* W		*/
    {  17,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x12, 0x00 }, 0x24, NULL },	/* E		*/
    {  18,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x13, 0x00 }, 0x2D, NULL },	/* R		*/
    {  19,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x14, 0x00 }, 0x2C, NULL },	/* T		*/
    {  20,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x15, 0x00 }, 0x35, NULL },	/* Y		*/
    {  21,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x16, 0x00 }, 0x3C, NULL },	/* U		*/
    {  22,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x17, 0x00 }, 0x43, NULL },	/* I		*/
    {  23,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x18, 0x00 }, 0x44, NULL },	/* O		*/
    {  24,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x19, 0x00 }, 0x4D, NULL },	/* P		*/
    {  25,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x1A, 0x00 }, 0x54, NULL },	/* {,[		*/
    {  26,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x1B, 0x00 }, 0x5B, NULL },	/* },]		*/
    {  27,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x1C, 0x00 }, 0x5A, NULL },	/* ENTER	*/
    {  28,  KEY_TYPE_NORMAL, KEY_MOD_PERM, { 0x3A, 0x00 }, 0x14, NULL },	/* CAPS		*/
    {  29,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x1E, 0x00 }, 0x1C, NULL },	/* A		*/
    {  30,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x1F, 0x00 }, 0x1B, NULL },	/* S		*/
    {  31,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x20, 0x00 }, 0x23, NULL },	/* D		*/
    {  32,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x21, 0x00 }, 0x2B, NULL },	/* F		*/
    {  33,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x22, 0x00 }, 0x34, NULL },	/* G		*/
    {  34,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x23, 0x00 }, 0x33, NULL },	/* H		*/
    {  35,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x24, 0x00 }, 0x3B, NULL },	/* J		*/
    {  36,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x25, 0x00 }, 0x42, NULL },	/* K		*/
    {  37,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x26, 0x00 }, 0x4B, NULL },	/* L		*/
    {  38,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x27, 0x00 }, 0x4C, NULL },	/* ;		*/
    {  39,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x28, 0x00 }, 0x52, NULL },	/* '		*/
    {  40,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x2B, 0x00 }, 0x5C, NULL },	/* \		*/
    {  41,  KEY_TYPE_NORMAL, KEY_MOD_MODI, { 0x2A, 0x00 }, 0x12, NULL },	/* LSHIFT	*/
    {  42,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x56, 0x00 }, 0x5C, NULL },	/* \		*/
    {  43,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x2C, 0x00 }, 0x1A, NULL },	/* Z		*/
    {  44,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x2D, 0x00 }, 0x22, NULL },	/* X		*/
    {  45,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x2E, 0x00 }, 0x21, NULL },	/* C		*/
    {  46,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x2F, 0x00 }, 0x2A, NULL },	/* V		*/
    {  47,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x30, 0x00 }, 0x32, NULL },	/* B		*/
    {  48,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x31, 0x00 }, 0x31, NULL },	/* N		*/
    {  49,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x32, 0x00 }, 0x3A, NULL },	/* M		*/
    {  50,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x33, 0x00 }, 0x41, NULL },	/* ,		*/
    {  51,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x34, 0x00 }, 0x49, NULL },	/* .		*/
    {  52,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x35, 0x00 }, 0x4A, NULL },	/* /		*/
    {  53,  KEY_TYPE_NORMAL, KEY_MOD_MODI, { 0x36, 0x00 }, 0x59, NULL },	/* RSHIFT	*/
    {  54,  KEY_TYPE_NORMAL, KEY_MOD_MODI, { 0x1D, 0x00 }, 0x11, NULL },	/* LCTRL	*/
    {  55,  KEY_TYPE_NORMAL, KEY_MOD_MODI, { 0x38, 0x00 }, 0x19, NULL },	/* LALT		*/
    {  56,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x39, 0x00 }, 0x29, NULL },	/* SPACE	*/
    {  57,  KEY_TYPE_NORMAL, KEY_MOD_MODI, { 0xE0, 0x38 }, 0x39, NULL },	/* RALT		*/
    {  58,  KEY_TYPE_NORMAL, KEY_MOD_MODI, { 0xE0, 0x1D }, 0x58, NULL },	/* RCTRL	*/
    {  59,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x01, 0x00 }, 0x08, NULL },	/* ESC		*/
    {  60,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x3B, 0x00 }, 0x07, NULL },	/* F1		*/
    {  61,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x3C, 0x00 }, 0x0F, NULL },	/* F2		*/
    {  62,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x3D, 0x00 }, 0x17, NULL },	/* F3		*/
    {  63,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x3E, 0x00 }, 0x1F, NULL },	/* F4		*/
    {  64,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x3F, 0x00 }, 0x27, NULL },	/* F5		*/
    {  65,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x40, 0x00 }, 0x2F, NULL },	/* F6		*/
    {  66,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x41, 0x00 }, 0x37, NULL },	/* F7		*/
    {  67,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x42, 0x00 }, 0x3F, NULL },	/* F8		*/
    {  68,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x43, 0x00 }, 0x47, NULL },	/* F9		*/
    {  69,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x44, 0x00 }, 0x4F, NULL },	/* F10		*/
    {  70,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x57, 0x00 }, 0x56, NULL },	/* F11		*/
    {  71,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x58, 0x00 }, 0x5E, NULL },	/* F12		*/
    {  72, KEY_TYPE_SPECIAL, KEY_MOD_NONE, { 0x00, 0x00 }, 0x57, ks_print },	/* PRINTSCREEN	*/
    {  73,  KEY_TYPE_NORMAL, KEY_MOD_PERM, { 0x46, 0x00 }, 0x5F, NULL },	/* SCROL LOCK	*/
    {  74, KEY_TYPE_SPECIAL, KEY_MOD_NONE, { 0x00, 0x00 }, 0x62, ks_pause },	/* PAUSE	*/
    {  75,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x52 }, 0x67, ks_nav },	/* INSERT	*/
    {  76,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x47 }, 0x6E, ks_nav },	/* HOME		*/
    {  77,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x49 }, 0x6F, ks_nav },	/* PAGE UP	*/
    {  78,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x53 }, 0x64, ks_nav },	/* DELETE	*/
    {  79,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x4F }, 0x65, ks_nav },	/* END		*/
    {  80,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x51 }, 0x6D, ks_nav },	/* PAGE DOWN	*/
    {  81,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x48 }, 0x63, ks_nav },	/* UP		*/
    {  82,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x4B }, 0x61, ks_nav },	/* LEFT		*/
    {  83,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x50 }, 0x60, ks_nav },	/* DOWN		*/
    {  84,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x4D }, 0x6A, ks_nav },	/* RIGHT	*/
    {  85,  KEY_TYPE_NORMAL, KEY_MOD_PERM, { 0x45, 0x00 }, 0x76, NULL },	/* NUMLOCK	*/
    {  86,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x47, 0x00 }, 0x6C, NULL },	/* NUM 7	*/
    {  87,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x48, 0x00 }, 0x75, NULL },	/* NUM 8	*/
    {  88,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x49, 0x00 }, 0x7D, NULL },	/* NUM 9	*/
    {  89,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x4E, 0x00 }, 0x7C, NULL },	/* NUM +	*/
    {  90,  KEY_TYPE_PREFIX, KEY_MOD_NONE, { 0xE0, 0x35 }, 0x77, ks_numdiv },	/* NUM /	*/
    {  91,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x4B, 0x00 }, 0x6B, NULL },	/* NUM 4	*/
    {  92,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x4C, 0x00 }, 0x73, NULL },	/* NUM 5	*/
    {  93,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x4D, 0x00 }, 0x74, NULL },	/* NUM 6	*/
    {  94,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x37, 0x00 }, 0x7E, NULL },	/* NUM *	*/
    {  95,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x4F, 0x00 }, 0x69, NULL },	/* NUM 1	*/
    {  96,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x50, 0x00 }, 0x72, NULL },	/* NUM 2	*/
    {  97,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x51, 0x00 }, 0x7A, NULL },	/* NUM 3	*/
    {  98,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0xE0, 0x1C }, 0x79, NULL },	/* NUM RET	*/
    {  99,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x4A, 0x00 }, 0x84, NULL },	/* NUM -	*/
    { 100,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x52, 0x00 }, 0x70, NULL },	/* NUM 0	*/
    { 101,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x53, 0x00 }, 0x71, NULL },	/* NUM .	*/
    { 102,  KEY_TYPE_NORMAL, KEY_MOD_PERM, { 0xE0, 0x46 }, 0x5F, NULL },	/* BREAK (Ctrl+Pause)	*/
    	/* the break (Ctrl+Pause) key combination was originally Ctrl+ScrollLock in first PC,
    	   that's why it has to send the ScrollLock scancode instead of the pause code */
};

keylayout_t* keylayout_init(void)
{
    keylayout_t *layout;
    int i;

    layout = (keylayout_t*) malloc(sizeof(keylayout_t));
    memset(layout, 0, sizeof(keylayout_t));
    for(i=0; i < MAX_KEYDEFS; i++) {
	layout->keys[i].type = KEY_TYPE_NONE;
    }
    layout->count = KEYDEF_NR_DEFAULTS;
    layout->cleanup = keylayout_cleanup;
    /* fill with defaults */
    for (i=0; i<KEYDEF_NR_DEFAULTS; i++) {
	memcpy(&layout->keys[i], &keydef_defaults[i], sizeof(keydef_t));
    }
    
    return layout;
}

void keylayout_cleanup(keylayout_t *layout)
{
    if (layout) free(layout);
}
