#ifndef __KVMDEFS_H__
#define __KVMDEFS_H__
/*----------------------------------------
 *	Equates
 *--------------------------------------*/
#ifdef __cplusplus
namespace pp {
#endif

// max number of concurrent clients per link
#define PP_KVM_MAX_CONNECTIONS_PER_LINK 8

// upper limit for num of remote video links
#define PP_KVM_VIDEO_LINK_REMOTE_CNT 8
// upper limit for num of data links
#define PP_KVM_DATA_LINK_CNT 8

// video link IDs
#define PP_KVM_VIDEO_LINK_REMOTE_ID_MIN		0
#define PP_KVM_VIDEO_LINK_REMOTE_ID_MAX		(PP_KVM_VIDEO_LINK_REMOTE_ID_MIN + PP_KVM_VIDEO_LINK_REMOTE_CNT - 1)
#define PP_KVM_VIDEO_LINK_LOCAL_ID		(PP_KVM_VIDEO_LINK_REMOTE_ID_MAX + 1)
#define PP_KVM_VIDEO_LINK_CNT			(PP_KVM_VIDEO_LINK_LOCAL_ID + 1)

// data link IDs
#define PP_KVM_DATA_LINK_ID_MIN 0


/* FIXME: use pp_register_errnos() */
enum 
{
	PP_KVM_ERR_ASSIGN_DATALINK_ERROR         = -1000,    // Error assigning data link
	PP_KVM_ERR_ASSIGN_VIDEOLINK_ERROR        = -1001,    // Error assigning video link
	PP_KVM_ERR_PC_SHARE_NOT_ALLOWED_ERROR    = -1002,    // PCShare not allowed for this connection
	PP_KVM_ERR_SWITCH_DATA_LINK_ERROR        = -1003,    // Cannot switch to data link in CIM_library
	PP_KVM_ERR_SWITCH_LOCAL_VIDEO_ERROR      = -1004,    // Cannot switch the local video from (localAdmin <--> targetPort)
	PP_KVM_ERR_SWITCH_REMOTE_VIDEO_ERROR     = -1005,    // Cannot switch to remove video

	PP_KVM_ERR_RELEASE_DATA_LINK_ERROR       = -1006,    // Cannot release the data link 
	PP_KVM_ERR_RELEASE_VIDEO_LINK_ERROR      = -1007,    // Cannot release the video link
	PP_KVM_ERR_DISCONNECT_DATA_LINK_ERROR    = -1008,	 // Cannot disconnect the data link on CIM_library

	PP_KVM_ERR_USER_NOT_CONNECTED_ERROR      = -1009,	 // User not connected to the link
	PP_KVM_ERR_MAX_CONN_REACHED_ERROR        = -1010,	 // Max 8 Connection in PC shared mode has reached
};


typedef unsigned int connection_type_t;

typedef struct {

	u_char data_link;
	u_char video_link;
	u_short target_number;

} target_connection_t;
#ifdef __cplusplus
}
#endif

#endif //__KVMDEFS_H__
