#ifndef _KVM_KVM_DEFAULTS_H
#define _KVM_KVM_DEFAULTS_H

#include <liberic_misc.h>
#include <pp/kvm.h>

#include "kvm_internals.h"

typedef struct kvm_default_s kvm_default_t;

typedef int (*kvm_defaults_init_t) (kvm_default_t* def);

struct kvm_default_s {
    const char*  name;
    int    count;
    int	   pause;
    int    max_size;
    char*  names[KVM_MAX_KVM_ENTRIES+1];  /* extra slot for NULL end marker */
    char*  keys[KVM_MAX_KVM_ENTRIES+1];
    int8_t  show_in_rc[KVM_MAX_KVM_ENTRIES+1];
    kvm_defaults_init_t init;
};

/* Initializes the defaults module.
 * Required before calling pp_kvm_get_defaultkeys (or fellows). */
extern int  kvm_defaults_init(void);
extern void kvm_defaults_cleanup(void);

#if defined(PRODUCT_RIPCKIMXN)
extern int kvm_def_ripc_init(kvm_default_t* def);
#endif

#if defined (PRODUCT_XX01IP_ANY)
extern int kvm_def_xx01ip_init(kvm_default_t* def);
#endif

#if (defined (PRODUCT_LARA) && (defined(OEM_MINICOM) || defined(OEM_PEPPERCON) || defined(OEM_DAXTEN))) \
    || defined(OEM_SENTINEL) || defined(OEM_XCEEDIUM)
extern int kvm_def_minicom_init(kvm_default_t* def);
#endif

#if defined(PRODUCT_LARA) && (defined(OEM_ADDER) || defined(OEM_LINDY))
extern int kvm_def_adder_init(kvm_default_t* def);
#endif

#if defined(PRODUCT_XX01IP_ANY) || defined(PRODUCT_RIPCKIMXN)
extern int pp_kvm_put_defaults_to_keys(int idx);
#endif

#endif /* _KVM_KVM_DEFAULTS_H */
