/* system includes */
#include <arpa/inet.h>

#include <pthread.h>
#include <pp/base.h>
#include <pp/propchange.h>
#include <pp/kvm.h>
#include "link_client.h"
#include <pp_kernel_common.h>
#include <pp/um.h>
#include <pp/vector.h>

/* local includes */
#include "kvm_driver_base.h"
#include "kvm_defaults.h"
#include "debug.h"

using namespace pp;

static pthread_mutex_t init_mtx = PTHREAD_RECURSIVE_MUTEX_INITIALIZER_NP;

KvmDriverBase::KvmDriverBase()
{
    DP_VERBOSE("%s called\n", ___F);

    m_link_clients = vector_new(NULL, 16 /* capacity */, NULL /* del func */);
    m_mtx = init_mtx;
}

KvmDriverBase::~KvmDriverBase()
{
    assert(vector_size(m_link_clients) == 0);
    vector_delete(m_link_clients);
}

LinkClient*
KvmDriverBase::NewLinkClient(
	    eric_session_int_id_t session_id, pp_kvm_session_type_t session_type)
{
    LinkClient *client;
    
    client = new LinkClient(session_id, session_type, 0, 0);

    MUTEX_LOCK(&m_mtx);
    vector_add(m_link_clients, client);
    MUTEX_UNLOCK(&m_mtx);

    return client;
}


void
KvmDriverBase::SetUnitPortCount(u_char /*unit*/, u_short /*count*/)
{

}

u_short
KvmDriverBase::GetUnitPortCount (u_char /*unit*/)
{
	return 0;
}


void
KvmDriverBase::ChangeIpAddress( uint32_t /*ip*/, int /*ip_valid*/, uint32_t /*mask*/, int /*mask_valid*/, uint32_t /*gw*/, int /*gw_valid*/)
{
}

void
KvmDriverBase::SetLocalVideoState( u_char /*channel*/, int /*status*/)
{
}

int
KvmDriverBase::PortStatusChanged ( int, int, int )
{
    return PP_ERR;
}

void
KvmDriverBase::PortChanged(u_char channel, u_char unit, u_short port)
{
	//No Implementation 	
}

int
KvmDriverBase::ReleaseLinkClient ( LinkClient * client )
{
    int ret = PP_ERR;
    int i, cnt;
    LinkClient *client_i;

    MUTEX_LOCK(&m_mtx);

    // remove client from m_link_clients
    cnt = vector_size(m_link_clients);
    for (i = 0; i < cnt; i++) {
	client_i = (LinkClient*)vector_get(m_link_clients, i);
	if (client_i == client) {
	    vector_remove(m_link_clients, i);
	    break;
	}
    }
    if (i == cnt) goto bail;

    delete client;

    ret = PP_SUC;
bail:
    MUTEX_UNLOCK(&m_mtx);
    return ret;
}

int
KvmDriverBase::setLinkClientLinks(LinkClient* client, u_char data_link, u_char video_link)
{
    return PP_ERR;
}

int
KvmDriverBase::getDataLinkIdAtPort(int unit, int port, int *data_link_id)
{
    int ret = PP_ERR;
    int i, cnt;
    LinkClient *client_i;
    int link_id = -1;
    bool found = false;

    MUTEX_LOCK(&m_mtx);

    cnt = vector_size(m_link_clients);
    for (i = 0; i < cnt; i++) {
	client_i = (LinkClient*)vector_get(m_link_clients, i);
	if (client_i->GetTargetUnit() == unit 
		&& client_i->GetTargetPort() == port) {
	    if (!found) {
		link_id = client_i->GetDataLinkId();
		found = true;
	    } else {
		assert(link_id == client_i->GetDataLinkId());
	    }
	}
    }
    if (!found) goto bail;

    *data_link_id = link_id;
    ret = PP_SUC;
bail:
    MUTEX_UNLOCK(&m_mtx);
    return ret;
}

int
KvmDriverBase::getUnitAndPort(LinkClient* client,
	    int *unit_out, int *port_out)
{
    assert(client != NULL);

    *unit_out = client->GetTargetUnit();
    *port_out = client->GetTargetPort();

    return PP_SUC;
}

int
KvmDriverBase::getClientCntOnDataLink(int data_link_id, int *cnt_out)
{
    int i, cnt;
    LinkClient *client_i;
    int ret = PP_ERR;
    int found = 0;

    if (data_link_id < 0) goto bail;

    MUTEX_LOCK(&m_mtx);

    cnt = vector_size(m_link_clients);
    for (i = 0; i < cnt; i++) {
	client_i = (LinkClient*)vector_get(m_link_clients, i);
	if (client_i->GetDataLinkId() == data_link_id) {
	    found++;
	}
    }

    *cnt_out = found;
    ret = PP_SUC;

    MUTEX_UNLOCK(&m_mtx);
bail:
    return ret;
}

int
KvmDriverBase::getClientCntOnVideoLink(int video_link_id)
{
    int i, cnt;
    LinkClient *client_i;
    int found = 0;

    MUTEX_LOCK(&m_mtx);

    cnt = vector_size(m_link_clients);
    for (i = 0; i < cnt; i++) {
	client_i = (LinkClient*)vector_get(m_link_clients, i);
	if (client_i->GetVideoLinkId() == video_link_id) {
	    found++;
	}
    }

    MUTEX_UNLOCK(&m_mtx);

    return found;
}
