/* global includes */
#include <stdio.h>
#include <pp/base.h>
#include <pp_kernel_common.h>
#include <liberic_misc.h>
#include <pp/vsc.h>

/* local includes */
#include "ripc.h"
#include "debug.h"

using namespace pp;

/* Implementation of KvmDriver. This is the main class for KVM */

KvmRipc::KvmRipc()
{
    DP_VERBOSE("%s called\n", ___F);
}

int
KvmRipc::Switch ( LinkClient* client, u_char unit, u_short target_port,
				u_char* data_link, u_char* video_link)
{
    pthread_mutex_t *mtx = &_switchPortMtx;
    int error;
    int ret = 0;
    char key_seq[KVM_MAX_KEY_SEQ_SIZE];
    char unit_seq[4];
    char port_seq[4];

    u_char dl = client->GetDataLinkNumber();
    u_char vl = client->GetVideoLinkNumber();
    PP_ASSERT(vl, vl == dl);
    u_char channel = dl;

    DP_NOTICE("%s: switching to unit/port %hhu/%hu on channel %hhu\n", ___F, unit, target_port, channel);

    MUTEX_LOCK(mtx);

    /* generate key sequences  */
    snprintf(unit_seq, sizeof(unit_seq), "%d-%d", (unit)/10, (unit)%10);
    snprintf(port_seq, sizeof(port_seq), "%d-%d", (target_port+1)/10, (target_port+1)%10);
    /* TODO: is unit_seq computed correctly?  Currently only "0-0" for unit 0
     * has been verified. */
    snprintf(key_seq, sizeof(key_seq), "CTRL-CTRL-%s-%s", unit_seq, port_seq);
    DP_NOTICE("%s: sending keyseq '%s'\n", ___F, key_seq);

    /* switch the target_port, which triggers notification of target_port change */
    DP_NOTICE("%s: sending keyseq '%s'\n", ___F, key_seq);
    error = SendKeySeq (channel, key_seq);
    if (error) ret = -1;

    MUTEX_UNLOCK(mtx);

    *data_link = channel;
    *video_link = channel;

    return ret;
}

void
KvmRipc::SetLocalVideoState(u_char channel, int status)
{
    if (channel == 0 || channel == 1) {
	DP_VERBOSE("%s: got status %d on channel %hhu\n", ___F, status, channel);
        pp_vsc_set_local_video(channel, (status ? 1 : 0));
    } else {
	DP_ERROR("%s: channel %hhu not in {0, 1}\n", ___F, channel);
    }
}
