/**
 * retrieves MO Profiles out of the ldap database
 *   particular for a specific user and a specific MO
 *
 * Author: Thomas Breitfeld <thomas@peppercon.de>
 * Copyright 2003 Peppercon AG
 */

#ifndef _PP_LDAP_PROF_H
#define _PP_LDAP_PROF_H

#define LDAP_DEPRECATED 1

#include <ldap.h>
#include <pp/profile.h>
#include <pp/acl.h>

int pp_ldap_errno_base(void);
int pp_ldap_has_errno(int error);

// numbers are pretty big, in order to distinguish
// them from others in um lib... pretty hacky, I know... :-|
#define PP_LDAP_ERR_NO_ERROR               0
#define PP_LDAP_ERR_INTERNAL_ERROR         (pp_ldap_errno_base() + 0)
#define PP_LDAP_ERR_NO_PROFILE             (pp_ldap_errno_base() + 1)
#define PP_LDAP_ERR_CONFIG_ERROR           (pp_ldap_errno_base() + 2)
#define PP_LDAP_ERR_CONN_FAILED            (pp_ldap_errno_base() + 3)
#define PP_LDAP_ERR_OPERATION_FAILED       (pp_ldap_errno_base() + 4)
#define PP_LDAP_ERR_AUTH_FAILED            (pp_ldap_errno_base() + 5)
#define PP_LDAP_ERR_LOOKUP_AUTH_FAILED     (pp_ldap_errno_base() + 6)
#define PP_LDAP_ERR_MGR_AUTH_FAILED        (pp_ldap_errno_base() + 7)
#define PP_LDAP_ERR_NO_SUCH_TAG            (pp_ldap_errno_base() + 8)
#define PP_LDAP_ERR_DEVPROF_AMBIGUOUS      (pp_ldap_errno_base() + 9)
#define PP_LDAP_ERR_SRV_INCONSTISTENT      (pp_ldap_errno_base() + 10)

extern const char * norbox_base_dn;

/*
 * returns true if erla is PEMX discovered and
 * and params are there for getting infos out of the LDAP server
 * 
 * This function can also be called without initializing,
 * i.e. pp_ldap_init doesn't need to be called,
 * however result will be false then
 */
int pp_ldap_is_active(char** lds, char** lds_user);

/*
 * returns true if erla is not PEMX discovered but
 * there is a valid ldap user server in the config file
 *
 * This function can also be called without initializing,
 * i.e. pp_ldap_init doesn't need to be called,
 * however result will be false then
 */
int pp_ldap_mini_is_active(char** lds_user);

int pp_ldap_init(void);
void pp_ldap_cleanup(void);

void pp_ldap_clear_caches(void);

int pp_ldap_authenticate(int *auth, const char* moid, const char* name, 
                         const char* passwd, char **groupname);

int pp_ldap_get_profile(pp_profile_t **prof, const char* moid, const char* uid);


int pp_ldap_get_devprofile(pp_profile_t **prof, const char* moid);

void pp_ldap_assigned_devprof_add_listener(void(*changed_listener)(void));

void pp_ldap_assigned_devprof_clear_caches(void);

/* functions to handle temorary user ids for ldap users */

int pp_ldap_create_temp_uid(const char* name);
void pp_ldap_remove_temp_uid(int uid);
int pp_ldap_get_temp_uid(const char* name);
char* pp_ldap_get_temp_user(int uid);
char* pp_ldap_get_nbx_moname(void);

#endif /* _PP_LDAP_PROF_H */
