#ifndef _PP_POWERSWITCH_H
#define _PP_POWERSWITCH_H

#include <pp/cfg.h>

#define MIN_RESET_SIGNAL_DURATION	  100
#define DEF_RESET_SIGNAL_DURATION	  250
#define MAX_RESET_SIGNAL_DURATION	 2000

#define MIN_POWER_CYCLE_DURATION	 1000
#define DEF_POWER_CYCLE_DURATION	 4000
#define MAX_POWER_CYCLE_DURATION	20000

#define MIN_POWER_STDBY_DURATION	 3000
#define DEF_POWER_STDBY_DURATION	 5000
#define MAX_POWER_STDBY_DURATION	20000

#define MIN_POWER_SIGNAL_DURATION	  100
#define DEF_SHORT_POWER_SIGNAL_DURATION	  250
#define DEF_LONG_POWER_SIGNAL_DURATION	 5000
#define MAX_POWER_SIGNAL_DURATION	20000

#define PP_POWER_PORT_ID_INTERNAL	(1 << 0)
#define PP_POWER_PORT_ID_SERIAL_1	(1 << 1)
#define PP_POWER_PORT_ID_SERIAL_2	(1 << 2)
#define PP_POWER_PORT_ID_PSU_ADAPT      (1 << 3)
    
#define PWR_OBJ_PORT                    0
#define PWR_OBJ_DEVICE                  1
#define PWR_OBJ_DEVICE_ADDR		2
#define PWR_OBJ_EXTERNAL                3
#define PWR_OBJ_SWITCH_SHORT_NAME       4
#define PWR_OBJ_SWITCH_ID               5
#define PWR_OBJ_SWITCH_LONG_NAME        6

#define PWR_DATA_VOLTAGE                1
#define PWR_DATA_CURRENT                2
#define PWR_DATA_FREQ                   3

#define POWER_CAP_SWITCH		0x0001
#define POWER_CAP_GET_STATE		0x0002
#define POWER_CAP_GET_TEMP              0x0004
#define	POWER_CAP_SWITCH_EXT            0x0008 
#define POWER_CAP_SWITCH_SEQ            0x0010
#define POWER_CAP_RESET			0x0020
#define POWER_CAP_PORT_DELAYS		0x0040
#define POWER_CAP_SWITCH_SIMULTAN       0x0080
#define POWER_CAP_SWITCH_ALL            0x0100

#define PWR_SWITCH_NORMAL               0x00
#define PWR_SWITCH_SEQ                  0x01

#define PWR_CHANNEL_A                   0x00
#define PWR_CHANNEL_B                   0x01

#define PWR_EXT_1                       0x00
#define PWR_EXT_2                       0x01

/* initialize/cleanup powerswitch globals */
int pp_power_switch_init(void);
void pp_power_switch_cleanup(void);

int pp_power_switch_is_supported(const char * name, u_int port_id);

/* init/cleanup a certain port, not needed if pp_power_login() is used */
int pp_power_init(u_int port_id);
int pp_power_uninit(u_int port_id);

/* login/logout to the powerswitch on the specified port, opens the port and initializes the switch */
int pp_power_login(u_int port_id);
int pp_power_logout(u_int port_id);


int pp_power_lookup_devices(u_int port_id);

/* get the capabilities of the connected device as encoded in POWER_CAP_XXX */
int pp_power_get_caps(u_int port_id);

/* get the state of the selected port */
int pp_power_get_state(int port, int device_id, u_int port_id);

/* Get the count for the selected object. Valid objects are PWR_OBJ_PORT
 * and PWR_OBJ_DEVICE. */
int pp_power_get_count(int device_id, int object, u_int port_id);

char* pp_power_get_name(int idx, int device_id, int object, u_int port_id);
int pp_power_set_name(int port, int device_id, int object, u_int port_id, const char* name);
u_short* pp_power_get_port_delays(int port, int device_id, u_int port_id);
int pp_power_set_port_delays(int port, int device_id, u_int port_id, u_short* delay);
char* pp_power_get_temperature(int device_id, u_int port_id);
char* pp_power_get_data(int device_id, int channel, int type, u_int port_id);
int pp_power_get_delay_enable(int device_id, u_int port_id);
int pp_power_set_delay_enable(int device_id, u_char enable, u_int port_id);
int pp_power_ext_switch(int port, int device_id, u_char on, u_int port_id);
int pp_power_get_ext_state(int port, int device_id, u_int port_id);
int   pp_power_get_sw_version(int device_id, u_int port_id);
char* pp_power_get_current(int device_id, u_int port_id);
char* pp_power_get_short_name(const char *id);
char* pp_power_get_long_name(const char *id);
char* pp_power_get_cascaded_dev_addr(int port);
int pp_power_switch_kvm_ports(u_char kvm_unit, u_short kvm_port, int on);

/* switch the selected port to state 'on' */
int pp_power_switch(int port, int device, u_char on, int seq, u_int port_id);
int pp_power_switch_simultan(int device_id, u_short port_values, u_int port_id);
int pp_power_switch_all(int device_id, u_char on, u_int port_id);
int pp_power_reset(int port, int device_id, u_int port_id);
int pp_power_stdby_switch(int port, int device, u_char on, int seq, u_int port_id);
int pp_power_button(int port, int device, u_char pb_enabled, int seq, u_int port_id);
int pp_power_cycle(int port, int device_id, u_int port_id);
u_int pp_power_map_serial_port_to_id(u_int serial_port);
int pp_power_reconf_serial1_ch(pp_cfg_chg_ctx_t * ctx);
int pp_power_reconf_serial2_ch(pp_cfg_chg_ctx_t * ctx);
#if (defined(PP_FEAT_PCI_ADC) && defined(PP_FEAT_PSU_ADAPT))
void pp_power_check_current_state(void);
#endif    
#endif /* _PP_POWERSWITCH_H */
