/**	
 * This file contains the code that manages /System/Device/.
 * It corresponds to one device object.
 * 
 * (c)2006 Raritan,  georg.hoesch@raritan.com
 */

#ifndef __RDM_DEVICE_H__
#define __RDM_DEVICE_H__

#include "pp/RDM_Definitions.h"
#include "PP_RDM_BranchManager.h"


/**
 * A device object that manages a <Device> branch in RDM. It initializes all
 * values and it handles the updates by implementing a branchmanager based
 * on PP_RDM_BranchManager. Writable values are stored in the config system.
 */
class Device: public PP_RDM_BranchManager
{
public:
    /**
     * Create a new device object. Needs to be initialized with
     * initialize() before usage.
     * 
     * @param rdm        reference to rdm
     * @param deviceId   the id of this device (as in <Device>), will be copied
     */
    Device(CRDM* rdm, const char* deviceId);
    virtual ~Device();
    
    /**
     * return unique BranchManager name, same as getDeviceID() for this class.
     */
    virtual
    const char* GetName();

    /**
     * Get the device id of this device, \0 terminated string.
     */
    const char*
    getDeviceID();

    /**
     * Load the default values from the config system and write them to
     * RDM. No need to call this explicity until absolutely required.
     */
    int                                 // 0 or RDM error code
    loadValues();
    
    /**
     * Stores the writable values from RDM to the config system. No need
     * to call this explicitly until absolutely required.
     */
    int                                 // 0 or RDM error code
    saveValues( );

    /**
     * Get the Device node from the rdm database.
     * Returns NULL if node is not found.
     */
    CSXDB_Node* getDeviceNode();
    
    /**
     * Get the System node from the rdm database.
     * Returns NULL if node is not found.
     */
    CSXDB_Node* getSystemNode();

protected:
    
    /** 
     * Implements branchmanager Update().
     */
    virtual
    int                                 // 0 or RDM Error code
    Update (
	CSession    *pUserSession,      // User session or NULL for super user
	CSXDB_Node  *pNode,             // The Node to be appended too
	CSXDB_Node  *pData              // Ptr to data to append
    );

private:
    char   deviceID[RDM_MAX_ID];       // our devices ID
};


#endif // _DeviceSettings_h_


