/**	
 * This file contains the code the that maintains the /System/Device/DeviceSettings
 * branch. It also bridges relevant values from RDM to libpp_cfg.
 * 
 * (c)2006 Raritan,  georg.hoesch@raritan.com, scottc@raritan.com
 */

#ifndef __DEVICESETTINGS_H__
#define __DEVICESETTINGS_H__

#include "pp/RDM_Definitions.h"
#include "PP_RDM_BranchManager.h"
#include "Device.h"


/**
 * A devicesettings object that manages the <DeviceSettings> branch in RDM.
 * It initializes all values and it handles the updates by implementing a
 * branchmanager based on PP_RDM_BranchManager. Writable values are stored
 * in the config system.
 */
class DeviceSettings: public PP_RDM_BranchManager
{
public:
    /**
     * Create a new devicesettings object. Needs to be initialized with
     * initialize() before usage.
     * 
     * @param deviceId  the id of this device (as in <Device>), will be copied
     */
    DeviceSettings(CRDM* pRDM, Device* parentDevice);
    virtual ~DeviceSettings();
    
    /**
     * return unique BranchManager name, uses a variation of parentDevice->GetName().
     */
    virtual
    const char*
    GetName();
    
    /** 
     * Loads the DeviceSettings branch of the database. Don't call this
     * explicitly until you have to.
     */
    int                                 // 0 or RDM error code
    loadDeviceSettings();
    
    /** 
     * Stores the writable settings of the <DeviceSettings> in libpp_cfg.
     * This will be called automatically after a write. Users usually
     * do not have to call this.
     */
    int
    saveDeviceSettings( );              // 0 or RDM error code

protected:

    /**
     * Get the DeviceSettings/Device node from the rdm database.
     * Returns NULL if node is not found.
     */
    CSXDB_Node* getDeviceSettingsNode();
    
    /** 
     * Implements branchmanager Update().
     */
    virtual
    int                                 // 0 or RDM Error code
    Update (
	CSession    *pUserSession,      // User session or NULL for super user
	CSXDB_Node  *pNode,             // The Node to be appended too
	CSXDB_Node  *pData              // Ptr to data to append
    );

    /**
     * Validates parsed data, pUsrData is a DS_DeviceSettings* (defined internally only).
     */
    int                                 // 0 or RDM Error code
    ValidateDeviceSettingsData (
	void* pUsrData                  // user data to be validated
    );

    /**
     * Validates parsed data, pUsrData is a DS_DeviceAccess* (defined internally only).
     */
    int                                 // 0 or RDM Error code
    ValidateDeviceAccessConfig (
	void* pUsrData                  // user data to be validated
    );

    /**
     * Validates parsed data, pUsrData is a DS_Interface* (defined internally only).
     */
    int                                // 0 or RDM Error code
    ValidateNetworkInterfaceConfig (
	void* pUsrData                 // user data to be validated
    );

private:
    char    uniqueBMname[RDM_MAX_ID];  // our devices ID
    Device* parentDevice;              // our parent device
};


#endif // _DeviceSettings_h_

