/**
 * PP_DDA_object.cpp
 * 
 * Peppercon DDA objects, derived from CDDA_Device, CDDA_Port and CDDA_Path.
 * Implement WriteData functions with code that stores the corresponding values
 * in the config system.
 *
 * (c) 2006 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#include <stdlib.h>
#include <pp/syms.h>
#include <pp/cfg.h>

#include "PP_DDA_objects.h"

/*
 * Device object
 */

PP_DDA_Device::PP_DDA_Device(CRDM* rdm)
    : CDDA_Device(rdm)
{
    // internal constructor, nothing to do
}

PP_DDA_Device::PP_DDA_Device(CRDM* rdm, const char* pID, const char* pType,
                             const char* pModel, int baseDevice)
    : CDDA_Device(rdm)
{
    // default constructor, user initialize() to do the work
    initialize(rdm, pID, pType, pModel, baseDevice);
}

void
PP_DDA_Device::initialize(CRDM* rdm, const char* pID, const char* pType,
                          const char* pModel, int baseDevice)

{
    // FIXME: retrieve name of device here (from config-sys? from rdm-devicesettings?)
    
    CDDA_Device::initialize(rdm, pID, pType, pModel, "Lara", baseDevice);
};

int
PP_DDA_Device::WriteData(const char * NOTUSED(pID), const char * NOTUSED(pKey), const char * NOTUSED(pData)) {
    // supported elements: Name
    
    // FIXME: store name in cfgsys or rdm-devicesettings
    return -1;
};

void
PP_DDA_Device::CommitData() { 
    // FIXME: flash configsystem ?
} 


/*
 * Port object
 */

PP_DDA_Port::PP_DDA_Port(CRDM* rdm)
    : CDDA_Port(rdm)
{
    // internal constructor, nothing to do
}

PP_DDA_Port::PP_DDA_Port (CRDM * rdm, PP_DDA_Device *parentDevice,
                          const char *pID, const char *pClass,
                          const char *pType, int internal)
    : CDDA_Port(rdm)
{
    initialize(rdm, parentDevice, pID, pClass, pType, internal);
}

void
PP_DDA_Port::initialize(CRDM * rdm, PP_DDA_Device *parentDevice,
                          const char *pID, const char *pClass,
                          const char *pType, int internal)
{
    char* name;
    
    if (pp_cfg_get_nodflt(&name, "rdm.port[%s]", pID) != PP_SUC) {
        name = strdup(pID);
    }

    CDDA_Port::initialize(rdm, parentDevice, pID, pClass, pType, name, -1, 1, internal, 1);

    free(name);

    // FIXME: load any other relevant values
    
}

int
PP_DDA_Port::WriteData( const char * NOTUSED(pID), const char *pKey, const char *pData ) {
    const char* _id = GetID();
    int ret = PP_ERR;
    printf("PP_DDA_Port::WriteData\n");
    
    if (strcmp(pKey, "Name") == 0) {
        ret = pp_cfg_set(pData, "rdm.port[%s]", _id);
    } else {
        printf("PP_CDDA_Port::WriteData: unknown data\n");
    }
    
    return ret;
}

void
PP_DDA_Port::CommitData() {
    pp_cfg_save(DO_FLUSH);
    printf("PP_CDDA_Port::CommitData\n");
}   


/*
 * PowerPort object
 */

PP_DDA_PowerPort::PP_DDA_PowerPort(CRDM* rdm)
    : PP_DDA_Port(rdm)
{
    next = NULL;
}

PP_DDA_PowerPort::PP_DDA_PowerPort (CRDM * rdm, PP_DDA_Device *parentDevice,
                                    const char *pID, const char *pType, int internal)
    : PP_DDA_Port(rdm)
{
    next = NULL;
    initialize(rdm, parentDevice, pID, pType, internal);
}

void
PP_DDA_PowerPort::initialize (CRDM * rdm, PP_DDA_Device *parentDevice,
                     const char *pID, const char *pType, int internal)
{
    PP_DDA_Port::initialize(rdm, parentDevice, pID, "Outlet", pType, internal);
}

int
PP_DDA_PowerPort::setPowerStateOfOutlet(int NOTUSED(state)) {
    return -1;
}   

char*
PP_DDA_PowerPort::getPowerStripStatus() {
    return NULL;
}      


/**
 * KVM Port object
 */

PP_DDA_KVMport::PP_DDA_KVMport (CRDM * rdm, PP_DDA_Device *parentDevice,
                 const char *pID, const char *pClass, const char *pType,
                 int internal)
    : PP_DDA_Port(rdm, parentDevice, pID, pClass, pType, internal)
{
}

void
PP_DDA_KVMport::associatePowerPort(PP_DDA_PowerPort* NOTUSED(powerPort)) {
}      
    
void
PP_DDA_KVMport::unassociatePowerPort(PP_DDA_PowerPort* NOTUSED(powerPort)) {
}    
    

    // FIXME: associate kvmports + outlets ?
    // for internal+ipmi power-ports: autoassociate the (only) KVM-port
    // for serial1+2 powerports: do nothing
    // do not allow changes on internal powerports  (FIXME: really not ?)
    // do allow (and store) changes on serial1+2 powerports

    // for one (internal) KVM port: 
    // get all internal+ipmi powerports (problem: can change dynamically)

    
