/**
 * pp_RDM_Power.cpp
 * 
 * Implements the RDM power services. Derives RDM_Power.cpp and
 * implements all the empty function calls.
 *
 * (c) 2004 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#include "pp/RDM.h"
#include "pp/RDMP.h"

#include "PP_RDM_Power.h"
#include "PP_RDM_intern.h"


PP_RDM_Power::PP_RDM_Power(CRDM* rdm): CRDM_Power(rdm) {
}
 
PP_RDM_Power::~PP_RDM_Power() {
   pRDM->rdmp.RemoveService( this );
}

int
PP_RDM_Power::DEP_SetPowerStateOfOutlet (char* pID, int state) {
    PP_DDA_PowerPort* port;
    port = getPowerPortById(pID);
    if (port == NULL) {
        printf("PP_RDM_Power: power port not found\n");
        return -1;
    }
    
    return port->setPowerStateOfOutlet(state);
}

char*
PP_RDM_Power::DEP_GetPowerStripStatus (char* pID) {
    PP_DDA_PowerPort* port;
    port = getPowerPortById(pID);
    if (port == NULL) {
        printf("PP_RDM_Power: power port not found\n");
        return NULL;
    }
    
    return port->getPowerStripStatus();
}

