/**
 * PP_RDM.h
 * 
 * The main file for accessing RDM functionality in PP firmware. 
 * Initializes the RDM database, keeps the RDM ports up to date
 * (powerports may be added dynamically), holds the local DDA
 * objects for the RDM database and opens the CSC connection.
 * 
 * Internal function prototypes.
 * 
 * (c) 2006 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */


#ifndef _PP_RDM_INTERN_H
#define _PP_RDM_INTERN_H

#include <pp/RDM.h>
#include "PP_DDA_objects.h"

/**
 * Get a DDA powerport object by its RDM datbase id.
 */
PP_DDA_PowerPort* getPowerPortById(const char* id);

/**
 * Get the id of the <device> node.
 */
const char* getDeviceID();

#endif /* _PP_RDM_INTERN_H */
