/**	
 *	@file	RDM_Protocol.h
 *	@brief	Definces the CCSCProtocol object for RDM
 *  This file defines the CRDM_Protocol_Factory and the CRDM_Protocol classes
 *  CRDM_Protocol_Factory is a CCSCProtocol object that is to be added to CSC
 *  When a new connetion is accepted, a thread is created and a CRDM_Protocol object is created
 */

#ifndef _RDM_Protocol_h_
#define _RDM_Protocol_h_

#include	"pp/CSCProtocol.h"
#include	"pp/Session.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

#define	RDM_IPR_RDM_CONDUIT_CLASS	0xA948535f

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

 class CNetConn;

/*----------------------------------------
 *	CRDM_Protocol_Factory Class
 *--------------------------------------*/

class CRDM_Protocol_Factory : public CCSCProtocol
{
public:

	CRDM_Protocol_Factory() : CCSCProtocol("RDM","SSL","1","1","None","CSC") {}

	/**
	 *	@brief	Override of CCSCProtocol::AcceptClientSocket
	 * 
	 *  Called when and "RDM" protocol TCP connection is accepted
	 *
	 *  @see CCSCProtocol
	 *
	 *  @param	pSession		The user session for this connection
	 * 	@param	s				The socket
	 *  @param	ipAddress		The client IP address
	 *  @param	tcpPort			The client TCP Port
	 */
public:
	virtual void AcceptClientSocket(CSession *pSession, CNetConn *pNetConn, int ipAddress, int tcpPort);
};

/*----------------------------------------
 *	CRDM_Protocol Class
 *--------------------------------------*/

class	CRDM_Protocol : public CSessionObject
{
public:

	CRDM_Protocol( CNetConn *pNetConn, CSession * pSession );

	virtual ~CRDM_Protocol();

	/** @see Session.h - CSessionObect */

	void
	Event
	(
		CSession	* pUserSession,		// The session in question...
		int			event,				// Which SESSION_EVENT_ code
		const void		*pData				// Data associated with the event
	);

	void
	Process
	(
	);		

private:
	OS_THREAD	hThread;				// Handle to our thread
	CNetConn *	pNetConn;			  	// Ptr to the network connection
	CSession *	pSession;				// Ptr to the session we are attached to

};

#endif // _RDM_Protocol_h_
