/**
 * PP_RDM.h
 * 
 * The main file for accessing RDM functionality in PP firmware. 
 * Initializes the RDM database, keeps the RDM ports up to date
 * (powerports may be added dynamically), holds the local DDA
 * objects for the RDM database and opens the CSC connection.
 * 
 * (c) 2006 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef _PP_RDM_H
#define _PP_RDM_H

#include <pp/RDM.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Open and initialize the rdm database.
 */
int pp_rdm_initialize_database(void);

/**
 * Cleanup the rdm database.
 */
void pp_rdm_cleanup_database(void);

extern "C" {
/**
 * Returns 1 if the device is currently managed by CC and the
 * CC is alive. This function can be used directly to determine
 * whether local logins are allowed or not.
 */
int pp_rdm_is_managed(void);

/**
 * Authenticate an existing rdm session (for rfb) by checking
 * session_id and session_key against the session entries in
 * RDM.
 */
int pp_rdm_authenticate_session(const char* session_id, const char* session_key);
}

#ifdef __cplusplus
}
#endif

/**
 * Get a pointer to the used (global) RDM object.
 */
CRDM* getRDM(void);


#endif /* _PP_RDM_H */
