/**
 * PP_RDM_c.h
 * 
 * C compatible functions of PP_RDM.h
 * 
 * (c) 2006 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef _PP_RDM_C_H
#define _PP_RDM_C_H

/**
 * Returns 1 if the device is currently managed by CC and the
 * CC is alive. This function can be used directly to determine
 * whether local logins are allowed or not.
 */
int  pp_rdm_is_managed(void);

/**
 * Authenticate an existing rdm session (for rfb) by checking
 * session_id and session_key against the session entries in
 * RDM.
 */
int pp_rdm_authenticate_session(const char* session_id, const char* session_key);

#endif /* _PP_RDM_C_H */
