/**	
 *	@file	ppUserObject.cpp
 *	@brief	Implementation oc CPPUsetObject
 * 
 *  CSC requires the function CSC_AuthenticateUser. This function must return a ptr
 *  to a user object. This user object is used by RDM to authorize access.
 *
 */

#include <strings.h>
#include <assert.h>
#include <stdio.h>

#include <pp/syms.h>
#include <pp/um.h>
#include <pp/CC.h>

#include "ppUserObject.h"

/*----------------------------------------
 *	static data
 *--------------------------------------*/

// global commandCenter variable from PP_RDM.cpp
extern CCommandCenter* commandCenter;

/** 
  * Authenticate a CSC session.
  */
bool CSC_AuthenticateUser
(
	const char	* name,
	const char	* password,
	DWORD		ipAddress,
	CUserObject 	** ppUserObject
)
{
    char ip_str[64];
    struct in_addr inAddr;
    int gid;

    *ppUserObject = commandCenter->Authenticate(name, password);
    if (*ppUserObject != NULL) {
    	// authenticated by <CommandCenter> entry in RDM
        return true;
    }

    // convert to ip doted string
    inAddr.s_addr = htonl(ipAddress);
    if(inet_ntop(AF_INET, &((struct sockaddr_in *)&inAddr)->sin_addr,
                         ip_str, sizeof(ip_str)) == NULL)
    {
	printf("CSC_AuthenticateUser -- User %s IP address conversion failed!\n", name);
	return false;
    }
    
    if (pp_um_user_authenticate_with_ip_str(name, password, PP_UM_AUTH_IGNORE_BLOCKING, ip_str, NULL, &gid) == PP_SUC)
    {
        printf("Authenticate User %s passed\n",name);
        // FIXME: need to figure out "UserID","Group","GroupID" 
        *ppUserObject = new CPPUserObject(name,"UserID","Group","GroupID");
        if (*ppUserObject == NULL)
        {
            return false;
        }
        return true;
    }
    
    return false;
}

/**
 * DEP_UpdateSessionHistory, needed by RDM/CSC. This is functionally related to 
 * authenticate so I did put this here ...
 */
bool                                //returns true on success, false otherwise.  
DEP_UpdateSessionHistory (
                const char* NOTUSED(pSessionID),
                const char* NOTUSED(pLoginTime),
                const char* NOTUSED(pLogoutTime),
                const char* NOTUSED(pLastResourceUsed),
                const char* NOTUSED(pUserID),
                const char* NOTUSED(pUserName),
                const char* NOTUSED(pGroupID))
{
    printf("TODO: DEP_UpdateSessionHistory()\n");
    return 1;
}

