#include <pp/rfb.h>
#include <pp/km.h>
#include <liberic_net.h>
#include <liberic_notify.h>
#include "rfb.h"
#include "debug.h"

static int rfb_apply_pointer_event(rfb_cl_t * clp, rfb_context_t *context,
				   short x, short y, short z,
				   u_char button_mask, u_char abs_rel,
				   u_int8_t type UNUSED,
				   eric_session_int_id_t session UNUSED) {      
    if (context->rfb_ptr_clp == NULL || context->rfb_ptr_clp == clp) {
	if (button_mask == 0) {
	    context->rfb_ptr_clp = NULL;
	} else {
	    context->rfb_ptr_clp = clp;
	}
    } else {
	return 0;	
    }

    pp_km_send_ptrmove(clp->data_link, x, y, z, button_mask, abs_rel);

#if defined(PP_FEAT_SESSION_REDIRECTOR)
    rfb_sas_send_mouse_event(x, y, z, button_mask, type, session, clp);
#endif /* PP_FEAT_SESSION_REDIRECTOR */
    
    return 0;
}

static int rfb_apply_keyboard_event(u_int8_t keycode, eric_session_int_id_t session UNUSED, rfb_cl_t *clp) {
    pp_km_send_keycodes(clp->data_link, &keycode, 1);

#if defined(PP_FEAT_SESSION_REDIRECTOR)
    rfb_sas_send_kbd_event(keycode, session, clp);
#endif /* PP_FEAT_SESSION_REDIRECTOR */

    return 0;
}	

#define	RFB_KEYBOARD_EVENT_PRIORITY	20
#define	RFB_POINTER_EVENT_PRIORITY	10

int rfb_enqueue_input_event(input_event_t *event) {
    int priority;

    if (event->type == rfbKeyEvent) {
	priority = RFB_KEYBOARD_EVENT_PRIORITY;
    } else if (event->type == rfbPointerEvent || event->type == rfbPointerRelativeEvent) {
	priority = RFB_POINTER_EVENT_PRIORITY;
    } else {
	goto error;
    }

    MUTEX_LOCK(&rfb_context.input_queue_mtx);
    if (!pp_queue_enqueue(rfb_context.input_queue, event,
			   sizeof(input_event_t), priority)) {
	sem_post(&rfb_context.input_sem);
	MUTEX_UNLOCK(&rfb_context.input_queue_mtx);
	return 0;
    }

 error:
    MUTEX_UNLOCK(&rfb_context.input_queue_mtx);
    return -1;
}

void* rfb_input_thread(void* arg) {
    rfb_context_t *context = (rfb_context_t*) arg;
    pp_queue_entry_t	*entry;
    input_event_t	*ie;
    static u_char  old_button_mask = 0xFF;
    static u_short old_x = 0;
    static u_short old_y = 0;
    static u_char  old_sent = 1;
    eric_session_int_id_t old_session = 0;
    int rem;
    
    while (context->input_thd_run) {
	sem_wait(&context->input_sem);
 	MUTEX_LOCK(&context->input_queue_mtx);
        entry = (pp_queue_entry_t*) pp_queue_dequeue(context->input_queue);
	sem_getvalue(&context->input_sem, &rem);
        MUTEX_UNLOCK(&context->input_queue_mtx);
	ie = entry->data;

	/*
	  printf("Got pointer event %d,%d,%d,%x (%d remaining)\n", be16_to_cpu(ie->pe.x),
	  be16_to_cpu(ie->pe.y), be16_to_cpu(ie->pe.z), ie->pe.button_mask, rem);
	*/

	if (ie->type == rfbKeyEvent) {
	    rfb_apply_keyboard_event(ie->data.keycode, ie->session, ie->clp);
	} else if (ie->type == rfbPointerRelativeEvent || ie->data.mouse_event.z != 0) {
	    rfb_apply_pointer_event(ie->clp, context, ie->data.mouse_event.x,
	    			    ie->data.mouse_event.y, ie->data.mouse_event.z,
				    ie->data.mouse_event.button_mask, PP_KM_PTR_MOVE_RELATIVE,
				    ie->type, ie->session);
	} else if (ie->data.mouse_event.button_mask != old_button_mask) {

	    if (!old_sent) {
		rfb_apply_pointer_event(ie->clp, context, old_x, old_y, 0,
					old_button_mask, PP_KM_PTR_MOVE_ABSOLUTE,
					ie->type, old_session);
		old_sent = 1;
	    }
	    rfb_apply_pointer_event(ie->clp, context, ie->data.mouse_event.x,
	    			    ie->data.mouse_event.y, 0,
				    ie->data.mouse_event.button_mask, PP_KM_PTR_MOVE_ABSOLUTE,
				    ie->type, ie->session);

	    old_button_mask = ie->data.mouse_event.button_mask;

	} else if (!rem || (ie->data.mouse_event.x < 10 && ie->data.mouse_event.y < 10)) {
	    rfb_apply_pointer_event(ie->clp, context, ie->data.mouse_event.x, ie->data.mouse_event.y, 0,
				    ie->data.mouse_event.button_mask, PP_KM_PTR_MOVE_ABSOLUTE,
				    ie->type, ie->session);

	    old_sent = 0;
	} else {
	    old_sent = 0;		
	}
		
	old_x = ie->data.mouse_event.x;
	old_y = ie->data.mouse_event.y;
	old_session = ie->session;
	
	free(entry->data);
	free(entry);
    }

    pp_queue_free(context->input_queue);
    sem_destroy(&context->input_sem);

    return NULL;
}
