#ifndef _PREDICTOR_H_
#define _PREDICTOR_H_

#include "rfb.h"

#define PRED_INTERVAL		 2

#define noPRED_DEBUG
#ifdef PRED_DEBUG
# define PD(fmt, args...)	{ printf("Pred: "fmt, ##args); }
#else
# define PD(fmt, args...)	{ }
#endif

#define PRED_BWIDTH_STATE_NONE		0
#define PRED_BWIDTH_STATE_REQ		1
#define PRED_BWIDTH_STATE_MEASURING	2
#define PRED_BWIDTH_STATE_DONE		3

int  pred_init(rfb_cl_t * clp);
void pred_cleanup(rfb_cl_t * clp);
void pred_measure_start(rfb_cl_t * clp, RegionRec *reg);
void pred_measure_stop(rfb_cl_t * clp);
void pred_predict_coding(rfb_cl_t * clp, RegionRec *reg);

#endif
