#include <pp/base.h>
#include <pp/rfb.h>
#include <liberic_net.h>
#include "rfb.h"
#include "debug.h"
#include "predictor.h"

#if !defined(PP_FEAT_VSC_HW_ENCODING)

/**
 * the update function for software encoding of the modified
 * region out of a single global framebuffer (old VSC1 method)
 */
int rfb_send_update_softenc(rfb_cl_t * clp, RegionRec *req_reg, int full_update) {
    char * fbu;
    size_t size;
    int n_upd_reg_rects;
    int upd_reg_a = 0;
    int i, ret = 0;
    int video_optimized = clp->enc.video_optimized;
    
    /* get the current modified region from grabber */
    if (pp_grab_request_region(clp->grab_client,
			       full_update ? GRAB_REQ_FLAGS_IGNORE_DIFFMAP : GRAB_REQ_FLAGS_NONE,
			       req_reg, &clp->ack_reg, NULL))
	{
	    return -1;
	}

    /* empty ack region, maybe no diff to transmit, try again later */
    if (!REGION_NOTEMPTY(&clp->ack_reg)) {
	clp->fb_update_requested = 1;
	return 0;
    }
    
    rfb_prepare_encoding(clp);

    /* the predictor may override our encoding settings */
    if (clp->pred_type != PRED_TYPE_NONE) {
	pred_predict_coding(clp, &clp->ack_reg);
    }
    
    if (clp->enc.pref_enc == rfbEncodingTight) {
	n_upd_reg_rects = 0;

	for (i = 0; i < REGION_NUM_RECTS(&clp->ack_reg); i++) {
	    int x = REGION_RECTS(&clp->ack_reg)[i].x1;
	    int y = REGION_RECTS(&clp->ack_reg)[i].y1;
	    int w = REGION_RECTS(&clp->ack_reg)[i].x2 - x;
	    int h = REGION_RECTS(&clp->ack_reg)[i].y2 - y;
	    int n = rfb_num_coded_rects_tight(clp, x, y, w, h);
	    if (n == 0) {
		n_upd_reg_rects = 0xFFFF;
		break;
	    }
	    n_upd_reg_rects += n;
	}
    } else {
	n_upd_reg_rects = REGION_NUM_RECTS(&clp->ack_reg);
    }
    
    fbu = rfb_create_fb_update_pdu(n_upd_reg_rects,
    	clp->connection_flags & (rfbConnectionFlagSasHW | rfbConnectionFlagSasSW),
    	full_update, &size);
    if (!fbu || size == 0) {
    	return -1;
    }

    memcpy(clp->update_buf, fbu, size);
    clp->ub_len = size;
    free(fbu);
   
    pred_measure_start(clp, &clp->ack_reg);

    if (video_optimized) {
	pp_grab_sync_frame_buffer(clp->video_link, GRAB_SYNC_LOCK);
    }

    clp->useTightCache = 0;
    if (clp->enc.tightCacheEnabled) {
	for (i = 0; i < REGION_NUM_RECTS(&clp->ack_reg); i++) {
	    upd_reg_a += (REGION_RECTS(&clp->ack_reg)[i].x2 - REGION_RECTS(&clp->ack_reg)[i].x1) *
		(REGION_RECTS(&clp->ack_reg)[i].y2 - REGION_RECTS(&clp->ack_reg)[i].y1);
	}
	if (upd_reg_a >= rfbTightCacheMinUpdRegA) clp->useTightCache = 1;	
    }
    
    for (i = 0; i < REGION_NUM_RECTS(&clp->ack_reg); i++) {
	int x = REGION_RECTS(&clp->ack_reg)[i].x1;
	int y = REGION_RECTS(&clp->ack_reg)[i].y1;
	int w = REGION_RECTS(&clp->ack_reg)[i].x2 - x;
	int h = REGION_RECTS(&clp->ack_reg)[i].y2 - y;
	int send_ret;

	send_ret = clp->enc.send_rect_softenc_fn(clp, x, y, w, h);

	if (send_ret == -1) {
            if (video_optimized) {
		pp_grab_sync_frame_buffer(clp->video_link, GRAB_SYNC_UNLOCK);
            }
	    return -1;
	}
    }

    if (video_optimized) {
	pp_grab_sync_frame_buffer(clp->video_link, GRAB_SYNC_UNLOCK);
    }

    ret = rfb_send_update_buf(clp);

    pred_measure_stop(clp);
    
#ifdef TIME_MEASURE
    pp_hrtime_stop(&clp->time_all);
    clp->time_ns_all = pp_hrtime_read(&clp->time_all);
    clp->time_ns += clp->time_ns_all;
    pp_hrtime_start(&clp->time_req);
#endif
   
    return ret;
}
#endif /* !defined(PP_FEAT_VSC_HW_ENCODING) */

