/*
 * translate.c - translate between different pixel formats
 */

/*
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include <stdio.h>
#include <byteswap.h>
#include <netinet/in.h>
#include "rfb.h"

#if 0
static void PrintPixelFormat(rfbPixelFormat * pf);
#endif

static int rfb_economic_translate = 0;

/*
 * Structure representing pixel format for RFB server (i.e. us).
 */

rfbPixelFormat rfb_pix_fmt;

/*
 * LUT for Tight 1-Bit-Encoding.
 */

u_int8_t tightLUT1BitFullColorBlackWhite[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1,
	0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1,
	0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1,
	0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 
	0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1,
	0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1,
	0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1,
	0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

/*
 * LUT for Tight 2-Bit-Encoding.
 */

u_int8_t tightLUT2BitFullColorGrayscale[] = {
	0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1,
	0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2,
	1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 3, 
	0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1,
	0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2,
	1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 3, 3, 
	0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1,
	0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2,
	1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 
	0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
	1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2,
	1, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 3, 3, 3
};

/*
 * LUT's for Tight 4-Bit-Encoding.
 */

u_int8_t tightLUT4BitFullColorGrayscale[] = {
	 0,  0,  0,  0,  1,  1,  2,  3,  0,  0,  1,  1,  2,  3,  3,  4, 
	 1,  1,  2,  3,  3,  4,  5,  6,  2,  3,  3,  4,  5,  6,  7,  8, 
	 3,  4,  5,  6,  7,  8,  8,  9,  5,  6,  7,  8,  8,  9, 10, 11, 
	 7,  7,  8,  9, 10, 11, 12, 12,  8,  9, 10, 11, 12, 12, 13, 13, 
	 0,  0,  0,  1,  1,  2,  3,  3,  0,  1,  1,  2,  3,  3,  4,  5, 
	 1,  2,  2,  3,  4,  5,  6,  7,  2,  3,  4,  5,  6,  7,  7,  8, 
	14,  5,  6,  7,  7,  8,  9, 10,  6,  7,  7,  8,  9, 10, 11, 12, 
	 7,  8,  9, 10, 11, 12, 12, 13,  9, 10, 11, 12, 12, 13, 13, 15, 
	 0,  0,  1,  1,  2,  2,  3,  4,  1,  1,  2,  2,  3, 14,  5,  6, 
	 2,  2,  3, 14,  5,  6,  7,  7,  3, 14,  5,  6,  7,  7,  8,  9, 
	 5,  6,  7,  7,  8,  9, 10, 11,  7,  7,  8,  9, 10, 11, 12, 12, 
	 8,  9, 10, 11, 12, 12, 13, 13, 10, 11, 12, 12, 13, 13, 15, 15, 
	 0,  1,  1,  2,  2,  3, 14,  5,  1,  2,  2,  3, 14,  4,  6,  7, 
	 2,  3, 14,  4,  6,  7,  7,  8, 14,  4,  6,  7,  7,  8,  9, 10, 
	 6,  7,  7,  8,  9, 10, 11, 12,  7,  8,  9, 10, 11, 12, 12, 13, 
	 9, 10, 11, 11, 12, 13, 13, 15, 11, 11, 12, 13, 13, 15, 15, 15
};

u_int8_t tightLUT4BitFullColor16Colors[] = {
	 0,  0,  1,  1,  1,  1,  2,  2,  0,  0,  1,  1,  1,  1,  2,  2, 
	 3,  3,  4,  4,  4,  4,  2,  2,  3,  3,  4,  4,  4,  4,  4,  2, 
	 3,  3,  4,  4,  4,  4,  4,  5,  3,  3,  4,  4,  4,  4,  5,  5, 
	 6,  6,  6,  4,  4,  5,  5,  5,  6,  6,  6,  6,  5,  5,  5,  5, 
	 7,  7,  8,  8,  8,  8,  2,  2,  7,  7,  8,  8,  8,  8,  2,  2, 
	 9,  9, 10, 10, 10, 10, 10,  2,  9,  9, 10, 10, 10, 10, 10, 10, 
	 9,  9, 10, 10, 10, 10, 10, 11,  9,  9, 10, 10, 10, 10, 11,  5, 
	 6,  6, 10, 10, 10, 11,  5,  5,  6,  6,  6, 10, 11,  5,  5,  5, 
	 7,  7,  8,  8,  8,  8, 12, 12,  7,  7,  8,  8,  8,  8, 12, 12, 
	 9,  9, 10, 10, 10, 10, 10, 12,  9,  9, 10, 10, 10, 10, 11, 11, 
	 9,  9, 10, 10, 10, 11, 11, 11,  9,  9, 10, 10, 11, 11, 11, 11, 
	13, 13, 10, 11, 11, 11, 11, 11, 13, 13, 13, 11, 11, 11, 11, 14, 
	15, 15, 15, 15, 12, 12, 12, 12, 15, 15, 15, 15, 12, 12, 12, 12, 
	15, 15, 15, 15, 12, 12, 12, 12, 15, 15, 15, 10, 11, 11, 11, 12, 
	13, 13, 13, 11, 11, 11, 11, 11, 13, 13, 13, 11, 11, 11, 11, 14, 
	13, 13, 13, 11, 11, 11, 14, 14, 13, 13, 13, 13, 11, 14, 14, 14
};

/*
 * Some standard pixel formats.
 */

static const rfbPixelFormat bgr233_pix_fmt = {
    8, 8, 0, 1, 7, 7, 3, 0, 3, 6, 0, 0
};


/*
 * Macro to compare pixel formats.
 */

#define PF_EQ(x,y)								\
	((x.bitsPerPixel_8 == y.bitsPerPixel_8) &&		        	\
	 (x.depth_8 == y.depth_8) &&						\
	 ((x.bigEndian_8 == y.bigEndian_8) || (x.bitsPerPixel_8 == 8)) &&	\
	 (x.trueColour_8 == y.trueColour_8) &&					\
	 (!x.trueColour_8 || ((x.redMax_be16 == y.redMax_be16) &&		\
			    (x.greenMax_be16 == y.greenMax_be16) &&		\
			    (x.blueMax_be16 == y.blueMax_be16) &&		\
			    (x.redShift_8 == y.redShift_8) &&			\
			    (x.greenShift_8 == y.greenShift_8) &&		\
			    (x.blueShift_8 == y.blueShift_8))))

#define PF_EQ_NOBE(x,y)								\
	((x.bitsPerPixel_8 == y.bitsPerPixel_8) &&		        	\
	 (x.depth_8 == y.depth_8) &&						\
	 (x.trueColour_8 == y.trueColour_8) &&					\
	 (!x.trueColour_8 || ((x.redMax_be16 == y.redMax_be16) &&		\
			    (x.greenMax_be16 == y.greenMax_be16) &&		\
			    (x.blueMax_be16 == y.blueMax_be16) &&		\
			    (x.redShift_8 == y.redShift_8) &&			\
			    (x.greenShift_8 == y.greenShift_8) &&		\
			    (x.blueShift_8 == y.blueShift_8))))

#define CONCAT2(a,b) a##b
#define CONCAT2E(a,b) CONCAT2(a,b)
#define CONCAT3(a,b,c) a##b##c
#define CONCAT3E(a,b,c) CONCAT3(a,b,c)
#define CONCAT4(a,b,c,d) a##b##c##d
#define CONCAT4E(a,b,c,d) CONCAT4(a,b,c,d)

#define OUT 8
#include "tableinittctemplate.c"
#define IN 8
#include "tabletranstemplate.c"
#undef IN
#define IN 16
#include "tabletranstemplate.c"
#undef IN
#define IN 24
#include "tabletranstemplate.c"
#undef IN
#define IN 32
#include "tabletranstemplate.c"
#undef IN
#undef OUT

#define OUT 16
#include "tableinittctemplate.c"
#define IN 8
#include "tabletranstemplate.c"
#undef IN
#define IN 16
#include "tabletranstemplate.c"
#undef IN
#define IN 24
#include "tabletranstemplate.c"
#undef IN
#define IN 32
#include "tabletranstemplate.c"
#undef IN
#undef OUT

#define OUT 32
#include "tableinittctemplate.c"
#define IN 8
#include "tabletranstemplate.c"
#undef IN
#define IN 16
#include "tabletranstemplate.c"
#undef IN
#define IN 24
#include "tabletranstemplate.c"
#undef IN
#define IN 32
#include "tabletranstemplate.c"
#undef IN
#undef OUT

typedef void (*rfb_init_table_fn_t)(char ** table,
				    rfbPixelFormat * in,
				    rfbPixelFormat * out);

rfb_init_table_fn_t rfbInitTrueColourSingleTableFns[3] = {
    rfbInitTrueColourSingleTable8,
    rfbInitTrueColourSingleTable16,
    rfbInitTrueColourSingleTable32
};

rfb_init_table_fn_t rfbInitTrueColourRGBTablesFns[3] = {
    rfbInitTrueColourRGBTables8,
    rfbInitTrueColourRGBTables16,
    rfbInitTrueColourRGBTables32
};

rfb_translate_fn_t rfbTranslateWithSingleTableFns[4][3] = {
    { rfbTranslateWithSingleTable8to8,
      rfbTranslateWithSingleTable8to16,
      rfbTranslateWithSingleTable8to32 },
    { rfbTranslateWithSingleTable16to8,
      rfbTranslateWithSingleTable16to16,
      rfbTranslateWithSingleTable16to32 },
    { rfbTranslateWithSingleTable24to8,
      rfbTranslateWithSingleTable24to16,
      rfbTranslateWithSingleTable24to32 },
    { rfbTranslateWithSingleTable32to8,
      rfbTranslateWithSingleTable32to16,
      rfbTranslateWithSingleTable32to32 }
};

rfb_translate_fn_t rfbTranslateRawVSCWithSingleTableFns[4][3] = {
    { rfbTranslateRawVSCWithSingleTable8to8,
      rfbTranslateRawVSCWithSingleTable8to16,
      rfbTranslateRawVSCWithSingleTable8to32 },
    { rfbTranslateRawVSCWithSingleTable16to8,
      rfbTranslateRawVSCWithSingleTable16to16,
      rfbTranslateRawVSCWithSingleTable16to32 },
    { rfbTranslateRawVSCWithSingleTable24to8,
      rfbTranslateRawVSCWithSingleTable24to16,
      rfbTranslateRawVSCWithSingleTable24to32 },
    { rfbTranslateRawVSCWithSingleTable32to8,
      rfbTranslateRawVSCWithSingleTable32to16,
      rfbTranslateRawVSCWithSingleTable32to32 }
};

rfb_translate_fn_t rfbTranslateWithRGBTablesFns[4][3] = {
    { rfbTranslateWithRGBTables8to8,
      rfbTranslateWithRGBTables8to16,
      rfbTranslateWithRGBTables8to32 },
    { rfbTranslateWithRGBTables16to8,
      rfbTranslateWithRGBTables16to16,
      rfbTranslateWithRGBTables16to32 },
    { rfbTranslateWithRGBTables24to8,
      rfbTranslateWithRGBTables24to16,
      rfbTranslateWithRGBTables24to32 },
    { rfbTranslateWithRGBTables32to8,
      rfbTranslateWithRGBTables32to16,
      rfbTranslateWithRGBTables32to32 }
};

rfb_translate_fn_t rfbTranslateRawVSCWithRGBTablesFns[4][3] = {
    { rfbTranslateRawVSCWithRGBTables8to8,
      rfbTranslateRawVSCWithRGBTables8to16,
      rfbTranslateRawVSCWithRGBTables8to32 },
    { rfbTranslateRawVSCWithRGBTables16to8,
      rfbTranslateRawVSCWithRGBTables16to16,
      rfbTranslateRawVSCWithRGBTables16to32 },
    { rfbTranslateRawVSCWithRGBTables24to8,
      rfbTranslateRawVSCWithRGBTables24to16,
      rfbTranslateRawVSCWithRGBTables24to32 },
    { rfbTranslateRawVSCWithRGBTables32to8,
      rfbTranslateRawVSCWithRGBTables32to16,
      rfbTranslateRawVSCWithRGBTables32to32 }
};


/*
 * rfbSetTranslateFunction sets the translation function.
 */

int
rfb_set_translate_function(rfb_cl_t * clp)
{
    const char * fn = ___F;
#if 0
    pp_log("Pixel format for client %s:\n", clp->client_ip);
    PrintPixelFormat(&clp->pix_fmt);
#endif

    clp->rawvsc_translate_fn = NULL;
    clp->rawvsc_use_serverpixelformat = 0;
    clp->lrle_translate_fn = NULL;

    /*
     * Check that bits per pixel values are valid
     */

    if ((rfb_pix_fmt.bitsPerPixel_8 !=  8) && (rfb_pix_fmt.bitsPerPixel_8 != 16) &&
	(rfb_pix_fmt.bitsPerPixel_8 != 24) && (rfb_pix_fmt.bitsPerPixel_8 != 32)) {
	pp_log("%s(): server bits per pixel (%d) not 8, 16, 24 or 32 \n", fn, rfb_pix_fmt.bitsPerPixel_8);
	return -1;
    }

    if ((clp->pix_fmt.bitsPerPixel_8 != 8) &&
	(clp->pix_fmt.bitsPerPixel_8 != 16) && (clp->pix_fmt.bitsPerPixel_8 != 32)) {
	pp_log("%s(): client bits per pixel not 8, 16 or 32\n", fn);
	return -1;
    }

    if (!clp->pix_fmt.trueColour_8) {
	pp_log("%s(): color maps not supported\n", fn);
	return -1;
    }

    /*
     * bitsPerPixel_8 is valid, now work out how to translate
     */

    /* ? -> truecolour */
    if ((rfb_pix_fmt.bitsPerPixel_8 < 16) ||
	(!rfb_economic_translate && (rfb_pix_fmt.bitsPerPixel_8 == 16))) {
	
	/* we can use a single lookup table for <= 16 bitsPerPixel_8 */
	
	clp->translate_fn = rfbTranslateWithSingleTableFns
	    [rfb_pix_fmt.bitsPerPixel_8 / 8 - 1][clp->pix_fmt.bitsPerPixel_8 / 16];
	
	rfbInitTrueColourSingleTableFns[clp->pix_fmt.bitsPerPixel_8 / 16]
	    (&clp->translate_lookup_table,
	     &rfb_pix_fmt, &clp->pix_fmt);
	
	clp->rawvsc_translate_fn = rfbTranslateRawVSCWithSingleTableFns
	    [rfb_pix_fmt.bitsPerPixel_8 / 8 - 1][clp->pix_fmt.bitsPerPixel_8 / 16];
    } else {
	
	/* otherwise we use three separate tables for
	   red, green and blue */
	
	clp->translate_fn = rfbTranslateWithRGBTablesFns
	    [rfb_pix_fmt.bitsPerPixel_8 / 8 - 1][clp->pix_fmt.bitsPerPixel_8 / 16];
	
	clp->rawvsc_translate_fn = rfbTranslateRawVSCWithRGBTablesFns
	    [rfb_pix_fmt.bitsPerPixel_8 / 8 - 1][clp->pix_fmt.bitsPerPixel_8 / 16];
    }
    
    /* for LRLE we always translate to 16 bpp for now,
       it does further reduction by itself */
    clp->lrle_translate_fn = rfbTranslateWithSingleTableFns
	[rfb_pix_fmt.bitsPerPixel_8 / 8 - 1][16 / 16];
    
    rfbInitTrueColourSingleTableFns[16 / 16]
	(&clp->lrle_translate_lookup_table,
	 &rfb_pix_fmt, &rfb_pix_fmt);
    
    if (PF_EQ(clp->pix_fmt, rfb_pix_fmt)) {
	
	/* client & server the same */
	clp->rawvsc_translate_fn = rfb_translate_none_rawvsc;
    }
    else if (PF_EQ_NOBE(clp->pix_fmt, rfb_pix_fmt)) {
	
	/* client & server the same besides the big/little endian flag */
	clp->rawvsc_translate_fn = rfb_translate_none_rawvsc;
	clp->rawvsc_use_serverpixelformat = 1;
    }

    return 0;
}

#if 0
static void
PrintPixelFormat(rfbPixelFormat * pf)
{
    if (pf->bitsPerPixel_8 == 1) {
	pp_log("  1 bpp, %s sig bit in each byte is leftmost on "
		 "the screen.\n", (pf->bigEndian_8 ? "most" : "least"));
    } else {
	pp_log("  %d bpp, depth %d%s\n",pf->bitsPerPixel_8, pf->depth_8,
		 ((pf->bitsPerPixel_8 == 8) ? "" :
		  (pf->bigEndian_8 ? ", big endian" :
		   ", little endian")));
	if (pf->trueColour_8) {
	    pp_log("  true colour: max r %d g %d b %d, "
		     "shift r %d g %d b %d\n", pf->redMax_be16,
		     pf->greenMax_be16, pf->blueMax_be16, pf->redShift_8,
		     pf->greenShift_8, pf->blueShift_8);
	} else {
	    pp_log("  uses a colour map (not true colour).\n");
	}
    }
}
#endif
