#ifndef _PP_SERIAL_INTERNAL_H
#define _PP_SERIAL_INTERNAL_H

typedef struct {
    pp_serial_uninit_func_t init;
    pp_serial_uninit_func_t uninit;
} serial_port_callbacks_t;

typedef struct {
    int id;
    char * device_path;
    int	fd;
    int has_hw_flowctrl;
    pp_serial_usage_t usage;
    int need_reconfigure;
} serial_port_t;

extern pp_hash_i_t * serial_ports_hash;
extern serial_port_callbacks_t serial_port_callbacks[PP_SERIAL_USAGE_COUNT];
extern pthread_mutex_t serial_lock;

void serial_reconf_init(void);
void serial_reconf_cleanup(void);
pp_serial_usage_t str_to_usage(const char * str);

#endif /* _PP_SERIAL_INTERNAL_H */
